import React from 'react';
import { truncateString } from './../utils/string';

import { API_URL } from './../constants';

const ListAnnonceItem = ({annonce, onClick}) => {    
    
    return (
      <div        
        className="card col-mb-4 mr-5 mb-5"
        style={{ width: "18rem", cursor: "pointer" }}
        onClick={onClick}
      >
        <img
          className="card-img-top"
          src={`${API_URL}/${annonce.coverImage}`}
          style={{ height: '10rem'}}
          alt="Card image cap"
        />
        <div className="card-body">
          <h5 className="card-title">{annonce.title}</h5>
          <p className="card-text">{truncateString(annonce.description, 80)}</p>
        </div>
      </div>
    );
        
}

export default ListAnnonceItem