import React from 'react';

import { useMutation, gql } from "@apollo/client";
import { GraphQLID } from 'graphql';

const DELETE_ANNONCE_MUTATION = gql`
        mutation deleteAnnonce($annonceId: ID!) {
            deleteAnnonce(annonceId: $annonceId) {
                _id
                title
                type
                status
                published
                price
                description
                availabilityDate
                assessments {
                _id
                text
                }
            }
        }
    `;
    const [deleteAnnonce, { 
        loading: mutationLoading,
        error: mutationError,
        data 
    }] = useMutation(DELETE_ANNONCE_MUTATION); 


class ListAnnonceIt extends Component{
    constructor(props){
        super(props)
        this.state = {annonce}
    }
 
    render(){
        return(
            <li>
            <img src="img.jpeg"/>
            <h3>{annonce.title}</h3>
            <button onClick={e => this.onClickAnnonce(annonce._id)}>X</button>
        </li>

        )
    }
    onClickAnnonce(annonceId) {
        const id = GraphQLID.parseValue(annonceId);
        deleteAnnonce({ variables: { annonceId: id } });        
    } 
     
}