import org.graphstream.algorithm.Toolkit;
import org.graphstream.algorithm.generator.BarabasiAlbertGenerator;
import org.graphstream.algorithm.generator.Generator;
import org.graphstream.algorithm.generator.RandomGenerator;
import org.graphstream.algorithm.generator.WattsStrogatzGenerator;
import org.graphstream.graph.BreadthFirstIterator;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.SingleGraph;
import org.graphstream.stream.file.FileSource;
import org.graphstream.stream.file.FileSourceEdge;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.*;

public class Mesures {

    public String valeur = "";

    public String getValeur() {
        return valeur;
    }

    public void setValeur(String valeur) {
        this.valeur = valeur;
    }

    // fonction de génération d'un reseau aleatoire
    public Graph generer_Aleatoire(int taille, double degre) {

        Graph graph = new SingleGraph("Graphe aléatoire");
        System.setProperty("org.graphstream.ui.renderer", "org.graphstream.ui.j2dviewer.J2DGraphRenderer");
        graph.addAttribute("ui.quality");
        graph.addAttribute("ui.antialias");
        Generator g = new RandomGenerator(degre);
        g.addSink(graph);
        g.begin();

        for (int i = 0; i < taille; i++)
            g.nextEvents();
        g.end();
        return graph;
    }

    //fonction de génération d'un réseau BarabasiAlbert
    public Graph genererBA(int taille, double degre) {

        Graph graph = new SingleGraph("Barabàsi-Albert");
        Generator g = new BarabasiAlbertGenerator((int) degre);
        g.addSink(graph);
        g.begin();

        for (int i = 0; i < taille; i++) {
            g.nextEvents();
        }

        g.end();
        return graph;

    }


    // Générer des valeurs un fichier
    public void generateData(String nom_fichier) {
        try {
            PrintWriter printWriter = new PrintWriter(nom_fichier, "UTF-8");

            printWriter.write(getValeur());
            printWriter.close();

        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }


    }
    // la fonction de génération de distance du reseau de collaboration
    private double distancesReseau(Graph graph, int taille) {
        setValeur("");
        List<Node> sources = Toolkit.randomNodeSet(graph, taille);
        long[] dd = new long[50];
        sources.forEach(source -> {
            BreadthFirstIterator<Node> bf = new BreadthFirstIterator<>(source);
            while (bf.hasNext()) {
                Node v = bf.next();
                dd[bf.getDepthOf(v)]++;
            }
        });
        double dAvg = 0;
        for (int d = 0; d < dd.length; d++) {
            if (dd[d] > 0) {
                double pd = (double) dd[d] / (taille * graph.getNodeCount());
                dAvg += d * pd;


                setValeur(getValeur() + " \n" + d + " " + pd);
                generateData("src/main/resources/distributionDistance");

            }
        }

        return dAvg;
    }

    // Question bonus
    public Graph fonctVariante(int node, int degre, double p) {

        Graph graph = new SingleGraph("graph");

        Generator g = new WattsStrogatzGenerator(node,degre,p);

        g.addSink(graph);
        g.begin();
        while (g.nextEvents()) {
        }
        g.end();

        graph.display(false);
        return graph;
    }
        public static void main(String[] args){
        Mesures mes = new Mesures();
        //lecture fichier
        String filePath = "src/main/resources/com-dblp.ungraph.txt";
        Graph graph = new SingleGraph("g");
        graph.addAttribute("ui.quality");
        graph.addAttribute("ui.antialias");
        graph.addAttribute("ui.stylesheet","url('src/main/resources/design.css')");


        FileSource fs = new FileSourceEdge();
        fs.addSink(graph);

        try {
            fs.readAll(filePath);

        } catch (IOException e) {
            e.printStackTrace();
        }


        // Coefficient de clustering
        int noeuds = graph.getNodeCount();
        int liens = graph.getEdgeCount();
        System.out.println("Noeud = " + noeuds);
        System.out.println("Liens = " + liens);
        double degMoyen = Toolkit.averageDegree(graph);
        System.out.println("degré moyen = " + degMoyen);
        System.out.println("coefficient de clustering: " + Toolkit.averageClusteringCoefficient(graph));

        System.out.println("coefficient de clustering pour un réseau aléatoire de la même taille et du même degré moyen est : "
                + Toolkit.averageClusteringCoefficient(mes.generer_Aleatoire(noeuds,
                degMoyen)));
        String message;
/*
        //Connexité
        if (Toolkit.isConnected(graph))
            message = "le réseau est connexe";
        else message = "le réseau n'est pas connexe";
        System.out.println(message);
        System.out.println("Un réseau aléatoire de la même taille et degré moyen " +
                ((Toolkit.isConnected(mes.generer_Aleatoire(noeuds,
                        degMoyen))) ? " est" : "n'est pas") + " connexe");

        // distribution de degre
        int[] dd = Toolkit.degreeDistribution(graph);
        for (int i = 0; i < dd.length; i++) {
            if (dd[i] > 0) {
                System.out.printf("%6d %20f\n", i, (double) dd[i] / noeuds);
                mes.setValeur(mes.getValeur() + " \n" + i + " " + (double) dd[i] / noeuds);
                mes.generateData("src/main/resources/distDegre");

            }

        }
        // distribution des distances
        System.out.println("la distance moyenne dans DBLP = " + mes.distancesReseau(graph, 1000));
        Graph g2 = mes.generer_Aleatoire(noeuds, degMoyen);
        System.out.println("la distance moyenne dans le reseau aléatoire = "
                + Math.log(noeuds)/Math.log(Toolkit.averageDegree(g2)));

            Graph g_RA = mes.generer_Aleatoire(noeuds, degMoyen);
            Graph g_BA = mes.genererBA(noeuds, degMoyen);



            System.out.println("Noeud du reseau aleatoire = " + g_RA.getNodeCount());
            System.out.println("Noeud du reseau Barabasi-Albert = " + g_BA.getNodeCount());

            System.out.println("Liens du reseau aleatoire = " + g_RA.getEdgeCount());
            System.out.println("Liens du reseau Barabasi-Albert = " + g_BA.getEdgeCount());

            System.out.println("degré moyen du reseau aleatoire= " + Toolkit.averageDegree(g_RA));
            System.out.println("degré moyen du reseau Barabasi-Albert= " + Toolkit.averageDegree(g_BA));

            System.out.println("coefficient de clustering du reseau aleatoire : " + Toolkit.averageClusteringCoefficient(g_RA));
            System.out.println("coefficient de clustering du reseau Barabasi-Albert : " + Toolkit.averageClusteringCoefficient(g_BA));

            System.out.println("Le reseau aleatoire" + ((Toolkit.isConnected(g_RA)) ? " est" : " n'est pas") + " connexe");
            System.out.println("Le reseau Barabasi-Albert" + ((Toolkit.isConnected(g_BA)) ? " est" : " n'est pas") + " connexe");

            System.out.println("la distance moyenne dans le reseau aléatoire = " + Math.log(g_RA.getNodeCount())/Math.log(Toolkit.averageDegree(g_RA)));
            System.out.println("la distance moyenne dans le reseau de Barabasi-Albert  = " + Math.log(g_BA.getNodeCount())/Math.log(Math.log(g_BA.getNodeCount())));

            //Question 7
            System.out.println("Coeficient de clustering =  " +Toolkit.averageClusteringCoefficient( mes.fonctVariante(100, 4, 0.9)));
            mes.distancesReseau(g_RA,100);

            //graph.display();

 */

            /* PROPAGATION DANS UN RESEAU */
            Propagation propagation = new Propagation();
            Graph graph2 = mes.generer_Aleatoire(noeuds,degMoyen);

            double beta = 1.0/7.0;
            double mu = 1.0/15.0;
            System.out.println("Taux de propagation = "+ beta/mu);

            System.out.println("Le seuil épidémique du réseau de collaboration = "+ degMoyen/propagation.degVariance(graph));
            System.out.println("Le seuil épidémique du réseau aleatoire = "+ Toolkit.averageDegree(graph2)/propagation.degVariance(graph2));

            // Simulation 1er cas
           /* propagation.sansInfection(graph);
            propagation.infecterRandomNode(graph);
            propagation.propager(graph,1.0/7.0,1.0/15.0);
            //propagation.generateData("src/main/resources/premierCas");*/

           // propagation.reinitialisation();

            // Simulation 2e cas

            /*propagation.infecterRandomNode(graph);
            propagation.immunisationAleatoire(graph);
            Graph gs2 = propagation.propager(graph,1.0/7.0,1.0/15.0);
            //propagation.generateData("src/main/resources/deuxiemeCas");
            Graph gNewAleaatoire = propagation.removeInfectes(gs2);
            System.out.println("Le seuil épidémique du réseau avec stratégies d'immunisation aleatoire = "+ Toolkit.averageDegree(gNewAleaatoire)/propagation.degVariance(gNewAleaatoire));
            propagation.reinitialisation();*/


            // Simulation 3e cas


           /* propagation.infecterRandomNode(graph);
            propagation.immunisationSelective(graph);
            Graph gs3 =  propagation.propager(graph,1.0/7.0,1.0/15.0);
            //propagation.generateData("src/main/resources/troisiemeCas");
            Graph g4 = propagation.removeInfectes(gs3);
            System.out.println("Le seuil épidémique du réseau avec stratégies d'immunisation seclective = "+ Toolkit.averageDegree(g4)/propagation.degVariance(g4));*/


            // Comparaison réseau aléatoire et réseau Barabasi-albert
            Graph gA = mes.generer_Aleatoire(noeuds,50);
            System.out.println("taille du graphe aléatoire " + gA.getNodeCount());
            Graph gBBA = mes.genererBA(noeuds, degMoyen);

            // Premier Cas
           /* propagation.sansInfection(gA);
            propagation.infecterRandomNode(gA);
            propagation.propager(gA,beta,mu);
            propagation.generateData("src/main/resources/Cas1Aleatoire");

            propagation.reinitialisation();

            propagation.sansInfection(gBBA);
            propagation.infecterRandomNode(gBBA);
            propagation.propager(gBBA,beta,mu);
            propagation.generateData("src/main/resources/BBA1");


            Propagation.reinitialisation();*/

            //2e Cas
/*
            propagation.infecterRandomNode(gA);
            propagation.immunisationAleatoire(gA);
            Graph gA2 = propagation.propager(gA,beta,mu);
            propagation.generateData("src/main/resources/Cas2Aleatoire");
            Graph gNew = propagation.removeInfectes(gA2);
            System.out.println("Le seuil épidémique du réseau avec stratégies d'immunisation aleatoire = "+ Toolkit.averageDegree(gNew)/propagation.degVariance(gNew));
            propagation.reinitialisation();

            propagation.infecterRandomNode(gBBA);
            propagation.immunisationAleatoire(gBBA);
            Graph gA3 = propagation.propager(gBBA,beta,mu);
            propagation.generateData("src/main/resources/BBA2");
            Graph gNewS = propagation.removeInfectes(gA3);
            System.out.println("Le seuil épidémique du réseau avec stratégies d'immunisation aleatoire = "+ Toolkit.averageDegree(gNewS)/propagation.degVariance(gNewS));
            propagation.reinitialisation();*/

            //3e Cas
           // Graph gA3 = mes.generer_Aleatoire(100,3);

           /* propagation.infecterRandomNode(gA);
            propagation.immunisationSelective(gA);
            Graph gs4 =  propagation.propager(gA,beta,mu);
            propagation.generateData("src/main/resources/Cas3Aleatoire");
            Graph gNewss = propagation.removeInfectes(gs4);
            System.out.println("Le seuil épidémique du réseau avec stratégies d'immunisation seclective = "+ Toolkit.averageDegree(gNewss)/propagation.degVariance(gNewss));
            propagation.reinitialisation();

            propagation.infecterRandomNode(gBBA);
            propagation.immunisationSelective(gBBA);
            Graph gs5 =  propagation.propager(gBBA,beta,mu);
            propagation.generateData("src/main/resources/BBA3");
            Graph gNewsss = propagation.removeInfectes(gs5);
            System.out.println("Le seuil épidémique du réseau avec stratégies d'immunisation seclective = "+ Toolkit.averageDegree(gNewsss)/propagation.degVariance(gNewsss));*/


        }
}
