<?php

namespace App\Repository;

use App\Entity\Question;
use PDO;

class QuestionRepository extends Repository
{

    private AnswerRepository $answerRepository;

    public function __construct()
    {
        $this->answerRepository = new AnswerRepository();
    }

    public function getAllQuestions(bool $isRandom = true) {
        //$query = "SELECT * FROM Question order by random()";
        $query = "SELECT * FROM Question order by ". ($isRandom ? "random()":"id DESC");

        $statement = $this->getPdo()->query($query);
        $questions = [];
        while ($row = $statement->fetch(PDO::FETCH_ASSOC)) {
            $question = new Question($row['id'], $row['text']);
            $answers = $this->answerRepository->getAllAnswersForQuestion($row['id'],$isRandom);

            foreach ($answers as $answer)
            {
                $question->addAnswer($answer);
            }
            $questions[] = $question;
        }
        return $questions;
    }

    public function getQuestionById($id) {
        $query = "SELECT * FROM Question q WHERE id = :id ";
        $statement = $this->pdo->prepare($query);
        $statement->execute(['id' => $id]);
        $row = $statement->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            return null;
        }
        return new Question($row['id'], $row['text']);
    }

    public function createQuestion(Question $question): false|string
    {
        $query = "INSERT INTO public.question(text)	VALUES (:text);";
        $statement = $this->getPdo()->prepare($query);
        $statement->execute([
            'text' => $question->getText(),
        ]);

        $question->id = $this->getPdo()->lastInsertId();

        foreach ($question->answers as $answer)
        {
            $this->answerRepository->createAnswer($answer,$question->id);
        }

        // Retourner l'ID de la pizza insérée
        return $question->id;
    }

}

?>