<?php

namespace App\Repository;

use App\Entity\Answer;
use PDO;

class AnswerRepository extends Repository
{
    public function getAllAnswersForQuestion(int $questionId, bool $isRandom = false) {
        $query = "SELECT * FROM Answer WHERE question_id = :question_id order by ". ($isRandom ? "random()":"id ASC");
        $statement = $this->getPdo()->prepare($query);
        $statement->execute(['question_id' => $questionId]);
        $answers = [];
        while ($row = $statement->fetch(PDO::FETCH_ASSOC)) {
            $answer = new Answer($row['id'], $row['text'], $row['is_correct']);
            $answers[] = $answer;
        }
        return $answers;
    }

    public function createAnswer(Answer $answer, int $id)
    {
        $query = "INSERT INTO public.answer(question_id, text, is_correct) VALUES (:question_id, :text,:is_correct);";
        $statement = $this->getPdo()->prepare($query);
        $statement->execute([
            'question_id' => $id,
            'text' => $answer->getText(),
            'is_correct' => $answer->isCorrect()?0:1,
        ]);

        $answer->id = $this->getPdo()->lastInsertId();
    }
}