<?php

namespace App\Entity;

class Question {

    public function __construct(
        public ?int $id=null,
        public string $text='',
        public array $answers = []){
    }

    public function getId() {
        return $this->id;
    }

    public function getText() {
        return $this->text;
    }

    public function getAnswers() {
        return $this->answers;
    }

    public function addAnswer($answer) {
        $this->answers[] = $answer;
    }

    public function setCorrectAnswer($answerId) {
        foreach ($this->answers as $answer) {
            if ($answer->getId() === $answerId) {
                $answer->setCorrect(true);
            } else {
                $answer->setCorrect(false);
            }
        }
    }
}