<?php

use App\Controller\AnswerController;
use App\Controller\QuestionController;

return [
    // Routes pour les questions
    '/questions' => [
        'GET' => [QuestionController::class, 'getAllQuestions'],
        'POST' => [QuestionController::class, 'addQuestion'],
        'OPTIONS' => [AnswerController::class, 'addAnswer'],
    ],
    '/questions/fix' => [
        'GET' => [QuestionController::class, 'getAllQuestionsFix'],
    ],

    '/questions/{id}' => [
        'GET' => [QuestionController::class, 'getQuestionById'],
    ],

    // Routes pour les réponses
    '/questions/{questionId}/answers' => [
        'GET' => [AnswerController::class, 'getAllAnswers'],
        'POST' => [AnswerController::class, 'addAnswer'],
        'OPTIONS' => [AnswerController::class, 'addAnswer'],
    ],
];
