<?php
namespace App\Controller;

use App\Entity\Answer;
use App\Entity\Question;
use App\Repository\QuestionRepository;

class QuestionController {
    private $questionRepository;

    public function __construct()
   {
        $this->questionRepository = new QuestionRepository();
   }

    public function getAllQuestions() {
        return $this->questionRepository->getAllQuestions();
    }
    public function getAllQuestionsFix() {
        return $this->questionRepository->getAllQuestions(false);
    }

    public function getQuestionById(array $params) {
        $id = (int) $params['id'];
        // Logique pour récupérer la question depuis la base de données par exemple
        $question = new Question($id, 'Question avec l\'ID ' . $id);
        // Ajouter des réponses à la question
        $question->addAnswer(new Answer(1, 'Réponse 1'));
        $question->addAnswer(new Answer(2, 'Réponse 2'));
        $question->setCorrectAnswer(1); // Définir la première réponse comme correcte

        return $question;

    }

    public function addQuestion() {
        // Logique pour ajouter la question à la base de données par exemple
        // Ici, $data contiendra les données de la nouvelle question à ajouter

        $data = json_decode(file_get_contents('php://input'));
        $question = new Question(text:$data->text);

        foreach ($data->answers as $answer)
        {
            $question->addAnswer(new Answer(text: $answer->text,correct: $answer->correct));
        }
        $this->questionRepository->createQuestion($question);

        return "Question ajoutée avec succès";
    }
}
