<?php

use App\Router\Router;

spl_autoload_register(function ($class_name) {

    $class_name = str_replace('App\\','',$class_name);

    // Convertir le nom de la classe en chemin de fichier en remplaçant les antislashs par des barres obliques
    $file = '../src/' . str_replace('\\', '/', $class_name) . '.php';

    // Vérifier si le fichier de classe existe
    if (file_exists($file)) {
        // Inclure le fichier de classe
        include_once $file;
    }
});


header("Access-Control-Allow-Origin: *"); //Todo: A mettre dans le .htaccess

// Charger les routes à partir du fichier de configuration
$routes = require '../src/Router/routes.php';

$router = new Router();

// Ajouter les routes depuis le fichier de configuration
foreach ($routes as $path => $methods) {
    foreach ($methods as $name => $method) {
        $router->addRoute($name, $path, $method[0], $method[1]);
    }
}

// URL actuelle et méthode HTTP
$currentUrl = isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : '/';
$method = $_SERVER['REQUEST_METHOD'];
//Manipulation de la requête
$response = $router->handle($method, $currentUrl);

if (is_array($response) || is_object($response))
{
    header( 'content-type: application/json; charset=utf-8' );
    echo json_encode($response);
    return;
}
header('Content-Type: text/html; charset=utf-8');
echo $response;
