## Plan du cours

- A- Les tableaux indexés
- B- Les tableaux associatifs
- C- Les tableaux multidimensionnels
- D- Les fonctions
- E- Les générateurs
- F- Les chaînes de caractères

---

## A- Les tableaux indexés

### Création et manipulation

```php[2-3|4-5|7-9|11-12|14-23|25-34]
<?php
// 1. Création d'un tableau indexé
$fruits = ["Pomme", "Banane", "Cerise"];
// Syntaxe alternative (plus ancienne)
$couleurs = array("Rouge", "Vert", "Bleu");

// 2. Accès aux éléments
echo $fruits[0];  // "Pomme" (premier élément)
echo $fruits[2];  // "Cerise" (troisième élément)

// 3. Modification d'un élément
$fruits[1] = "Orange";  // Remplace "Banane" par "Orange"

// 4. Ajout d'éléments

// Ajoute à la fin
$fruits[] = "Kiwi";

// Ajoute à l'index 10          
$fruits[10] = "Ananas";
       
// Ajoute à la fin (fonction)       
array_push($fruits, "Mangue");

// 5. Suppression d'éléments

// Supprime l'élément à l'index 0
unset($fruits[0]);    

// Supprime le dernier élément
array_pop($fruits);   

// Supprime le premier élément
array_shift($fruits);
?>
```

---
## A- Les tableaux indexés
### Parcours des tableaux

```php[2|4-7|9-12|14-17]
<?php
$nombres = [10, 20, 30, 40, 50];

// Méthode 1 : foreach (recommandée)
foreach ($nombres as $nombre) {
    echo $nombre . " ";
}

// Méthode 2 : foreach avec index
foreach ($nombres as $index => $nombre) {
    echo "Index $index : $nombre\n";
}

// Méthode 3 : boucle for classique
for ($i = 0; $i < count($nombres); $i++) {
    echo "Élément $i : " . $nombres[$i] . "\n";
}
?>
```

---

## A- Les tableaux indexés
### Fonctions utiles

| Fonction     | Description             | Exemple             |
|--------------|-------------------------|---------------------|
| `count()`    | Nombre d'éléments       | `count($tab)`       |
| `empty()`    | Vérifie si vide         | `empty($tab)`       |
| `isset()`    | Vérifie existence index | `isset($tab[2])`    |
| `sort()`     | Tri croissant           | `sort($tab)`        |
| `rsort()`    | Tri décroissant         | `rsort($tab)`       |
| `in_array()` | Recherche valeur        | `in_array(3, $tab)` |

---
## B- Les tableaux associatifs
### Syntaxe et utilisation

```php[3-8|10-12|14-20|22-25|27-30]
<?php
// 1. Création d'un tableau associatif
$personne = [
    "nom" => "Dupont",
    "prenom" => "Jean",
    "age" => 35,
    "ville" => "Paris"
];

// 2. Accès aux éléments
echo $personne["nom"];     // "Dupont"
echo $personne["age"];     // 35

// 3. Modification et ajout

// Modifie l'âge
$personne["age"] = 36;

// Ajoute une nouvelle clé
$personne["email"] = "jean.dupont@email.com";

// 4. Suppression

// Supprime la clé "ville"
unset($personne["ville"]);

// 5. Vérification d'existence
if (isset($personne["email"])) {
    echo "Email : " . $personne["email"];
}
?>
```

---
## B- Les tableaux associatifs
## Parcours et fonctions spécialisées

```php[2-7|9-12|14-20|22-31]
<?php
$notes = [
    "Mathématiques" => 15,
    "Français" => 12,
    "Histoire" => 14,
    "Anglais" => 16
];

// Parcours avec clé et valeur
foreach ($notes as $matiere => $note) {
    echo "$matiere : $note/20\n";
}

// Fonctions spécifiques

// ["Mathématiques", "Français", "Histoire", "Anglais"]
array_keys($notes);

// [15, 12, 14, 16]
array_values($notes);    

// Tri associatif

// Tri par valeurs (conserve les associations)
asort($notes);

// Tri par clés   
ksort($notes);

// Tri par valeurs décroissant
arsort($notes);  
?>
```

---
## C- Les tableaux multidimensionnels
### Types de structures

```php[2-7|8|10-22|14-20|25-33]
<?php
// 1. Tableau 2D indexé (matrice)
$matrice = [
    [1, 2, 3],
    [4, 5, 6],
    [7, 8, 9]
];
echo $matrice[1][2]; // 6 (ligne 1, colonne 2)

// 2. Tableau 2D associatif
$etudiants = [
    [
        "nom" => "Martin",
        "age" => 20,
        "notes" => [15, 12, 18]
    ],
    [
        "nom" => "Durand", 
        "age" => 21,
        "notes" => [16, 14, 13]
    ]
];

// 3. Structure complexe d'entreprise
$entreprise = [
    "employés" => [
        "dev" => ["Alice", "Bob"],
        "design" => ["Charlie", "David"]
    ],
    "projets" => [
        "site_web" => ["statut" => "actif", "budget" => 5000],
        "app_mobile" => ["statut" => "terminé", "budget" => 8000]
    ]
];
?>
```

---

## C- Les tableaux multidimensionnels
### Manipulation et parcours

```php[2-11|13-19|21-22]
<?php
$equipes = [
    "Alpha" => [
        ["nom" => "Jean", "role" => "leader"],
        ["nom" => "Marie", "role" => "dev"]
    ],
    "Beta" => [
        ["nom" => "Paul", "role" => "design"],
        ["nom" => "Lisa", "role" => "test"]
    ]
];

// Parcours complet
foreach ($equipes as $nomEquipe => $membres) {
    echo "Équipe $nomEquipe :\n";
    foreach ($membres as $membre) {
        echo "- {$membre['nom']} ({$membre['role']})\n";
    }
}

// Ajout d'un membre
$equipes["Alpha"][] = ["nom" => "Tom", "role" => "marketing"];
?>
```

---

# D- Les fonctions

## Introduction aux fonctions

Depuis PHP 7 :
 - possibilité de **typer les paramètres** et le **type de retour**.


---
## D- Les fonctions
### Syntaxe de base et typage

```php[2-5|7-10|12-15|18-27]
<?php
// Fonction simple sans paramètres
function sayHello(): string {
    return "Bonjour tout le monde !";
}

// Fonction avec paramètres typés
function calculateSum(int $a, int $b): int {
    return $a + $b;
}

// Fonction avec paramètres par défaut
function greet(string $nom = "Visiteur", string $titre = "M./Mme"): string {
    return "Bonjour $titre $nom !";
}

// Types supportés
function exampleTypes(
    string $texte,        // Chaîne de caractères
    int $entier,          // Nombre entier
    float $decimal,       // Nombre décimal
    bool $boolean,        // Booléen
    array $tableau,       // Tableau
    ?string $optionnel    // string ou null
): void {                 // void = aucun retour
    // Traitement...
}
?>
```

---
## D- Les fonctions
### Types de données supportés

| Type | Description | Exemple |
|------|-------------|---------|
| `string` | Chaîne de caractères | `"Hello World"` |
| `int` | Nombre entier | `42` |
| `float` | Nombre décimal | `3.14` |
| `bool` | Booléen | `true`, `false` |
| `array` | Tableau | `[1, 2, 3]` |
| `?type` | Type nullable | `?string` (string ou null) |
| `void` | Aucun retour | Fonction qui ne retourne rien |

---
## D- Les fonctions
### Portée des variables et fonctions avancées

```php[2-13|15-18|20-23|25-31]
<?php
$globale = "Variable globale";

function exempleScope(): void {
    // Accès à la variable globale
    global $globale; 
    
    // Variable statique (persiste entre appels)
    static $compteur = 0;
    
    $compteur++;
    echo "Compteur : $compteur\n";
}

// Fonction avec références
function modifierTableau(array &$tableau): void {
    $tableau[] = "nouvel élément";
}

// Fonction récursive
function factorielle(int $n): int {
    return ($n <= 1) ? 1 : $n * factorielle($n - 1);
}

// Fonctions anonymes (closures)
$multiplier = function(int $x, int $y): int {
    return $x * $y;
};

// Fonctions fléchées (PHP 7.4+)
$doubler = fn($x) => $x * 2;
?>
```

---

## F- Les chaînes de caractères

**Quatre syntaxes de chaînes** :

1. **Simple quotes (`''`)** : Contenu littéral, variables non interprétées
2. **Double quotes (`""`)** : Variables interpolées, caractères d'échappement reconnus
3. **Heredoc** : Texte multiligne avec interpolation
4. **Nowdoc** : Texte multiligne sans interpolation

---
## F- Les chaînes de caractères
### Syntaxes et interpolation

```php[2-3|5-8|10-16|18-19|21-24|26-31|33-38]
<?php
$nom = "Alice";
$age = 25;

// 1. Simple quotes - Interprétation littérale

// Affiche: Bonjour $nom
$message1 = 'Bonjour $nom'; 

// 2. Double quotes - Interpolation de variables

// Affiche: Bonjour Alice
$message2 = "Bonjour $nom"; 

// Affiche: Tu as 25 ans
$message3 = "Tu as $age ans";

// 3. Syntaxe complexe avec accolades
$message4 = "Bonjour {$nom}, tu as {$age} ans";

// 4. Concaténation
$message5 = "Bonjour " . $nom . ", tu as " . $age . " ans";
$phrase = "Bonjour ";
$phrase .= $nom;  // Opérateur .= pour concaténer

// 5. Heredoc - Multilignes avec interpolation
$texteHeredoc = <<<EOT
Nom: $nom
Âge: $age
Message: Bienvenue sur notre site !
EOT;

// 6. Nowdoc - Multilignes sans interpolation
$texteNowdoc = <<<'EOT'
Nom: $nom
Âge: $age
Message: Les variables ne sont pas interprétées
EOT;
?>
```
---

# Questions ?