$(document).ready(function(){
    movement.initiateMovement();
});

var movement = {
    carRotation: 0,
    initiateMovement: function(){
        $('#front-arrow').hide();
        $('#back-arrow').hide();
        $('#left-front-arrow').hide();
        $('#left-back-arrow').hide();
        $('#right-front-arrow').hide();
        $('#right-back-arrow').hide();
    },
    rotateCar: function(degree){
        movement.carRotation += degree;
        $('#svg').css('transform', `rotate(${movement.carRotation}deg)`)
    },
    rotateBothFront: function(){
        movement.initiateMovement();
        $('#front-arrow').show();
        $('#left-front-arrow').show();
        $('#right-front-arrow').show();
    },
    rotateBothBack: function(){
        movement.initiateMovement();
        $('#back-arrow').show();
        $('#left-back-arrow').show();
        $('#right-back-arrow').show();
    },
    rotateLeftFront: function(){
        movement.initiateMovement();
        $('#front-arrow').show();
        $('#left-front-arrow').show();
        movement.rotateCar(15);
    },
    rotateRightFront: function(){
        movement.initiateMovement();
        $('#front-arrow').show();
        $('#right-front-arrow').show();
        movement.rotateCar(-15);
    },
    rotateLeftBack: function(){
        movement.initiateMovement();
        $('#back-arrow').show();
        $('#left-back-arrow').show();
        movement.rotateCar(-15);
    },
    rotateRightBack: function(){
        movement.initiateMovement();
        $('#back-arrow').show();
        $('#right-back-arrow').show();
        movement.rotateCar(15);
    },
    stopRotation: function(){
        movement.initiateMovement();
    }
};

var screen = {
    updateDisplay: function(distance){
        let color = "green";
        if(distance < 31){
            color = "red";
        }
        $('#distance')
            .css('background', color)
            .text(distance + "cm");
    }
};