#include <AFMotor.h>

AF_DCMotor motor1(1, MOTOR12_64KHZ); // Definition du moteur 1 (celui de gauche)
AF_DCMotor motor2(2, MOTOR12_64KHZ);// Definition du moteur 2 (celui de droite)

// Capteur ultrason
int trigPin = 1;    // Trigger
int echoPin = 2;    // Echo
long duration, cm;
const unsigned long period = 1000;    // la valeur est un nombre de millisecondes
int timer;// compteur de temps (1 = 1000ms par exemple)
int directionRnd = 0;  // une variable random pour décider si la voiture va tourner à gauche ou à droite

unsigned long startMillis;  //heure de début
unsigned long currentMillis; //heure actuelle

void setup()
{
  motor1.setSpeed(200);     // vitesse du moteur est figée à 200/255
  motor2.setSpeed(200);     // vitesse du moteur est figée à 200/255
  pinMode(trigPin, OUTPUT);// Mettre la variable trigPin en sortie 
  pinMode(echoPin, INPUT);// Mettre la variable echoPin en entrer
  Serial.begin(9600); // ouvre le port série, règle le débit de données à 9600 bps
  delay(random(500,2000));   // delay for random time
}

void loop()
{
  capteur(); // Fonction du capteur
  rouler(); // Fonction des mouvement de la voiture 
}


void rouler(){ // Fonction des mouvement de la voiture

  currentMillis = millis();  //recuperer le "temps" actuel (en fait, le nombre de millisecondes depuis le début du programme)
  if (currentMillis - startMillis >= period)  //tester si la période s'est écoulée
  {
    timer++; // incrementer le temps
    if (timer > 8) { // Si on atteint 8 (8000 ms)
      timer = 0; // remettre le timer a 0 s
      directionRnd = 0;
    }
    startMillis = currentMillis;  //IMPORTANT pour enregistrer l'heure de démarrage de l'état actuel de la LED.
  }

  if (cm >31)   // Si la distance est inferieur à 31cm     
  {
    //Serial.println(cm);
    motor1.run(FORWARD);      // Avancer
    motor2.run(FORWARD);      // Avancer
  }
  else if (cm < 30) // Si la distance est superieur à 30cm 
  {
    if (timer >= 0 && timer <= 2.5) {
      motor1.run(RELEASE);      //s'arreter
      motor2.run(RELEASE);      //s'arreter
      //delay(500);
    }else if (timer >= 2.5 && timer <= 5) {
      motor1.run(BACKWARD);      // Reculer
      motor2.run(BACKWARD);       // Reculer
      //delay(500);
    }else if (timer >= 5 && timer <= 5.5) {
      motor1.run(RELEASE);      //s'arreter
      motor2.run(RELEASE);      //s'arreter
      //delay(100);
    }else {
      if(directionRnd == 0){
        directionRnd = random(1,3);
      }
      if(directionRnd == 1){
        motor1.run(FORWARD);       // Avancer
        motor1.run(RELEASE);      // s'arreter
      }else{
        motor2.run(FORWARD);       // Avancer
        motor2.run(RELEASE);      // s'arreter
      }
      //delay(500);
    }
  }
}

void capteur(){ // Fonction du capteur

  digitalWrite(trigPin, LOW); // eteindre le trigPin rouge
  delayMicroseconds(5); // Pendant 5 microseconde
  digitalWrite(trigPin, HIGH);// Allumer le trigPin rouge
  delayMicroseconds(10); // Pendant 10 microseconde
  digitalWrite(trigPin, LOW);// eteindre le trigPin rouge

  pinMode(echoPin, INPUT); // Mettre la variable echoPin en entrer
  duration = pulseIn(echoPin, HIGH);// recuperer la durée

  // Convertir le temps en distance
  cm = (duration / 2) / 29.1;
  delay(10);// Pendant 10 microseconde
  Serial.print(cm);// Afficher la distance en cm
  Serial.println(" cm"); // afficher "cm"
}
