$(document).ready(function(){
    movement.initiateMovement();
    connectToWebsocket();
});

var movement = {
    carRotation: 0,
    rotationValue: 1,
    initiateMovement: function(){
        $('#front-arrow').hide();
        $('#back-arrow').hide();
        $('#left-front-arrow').hide();
        $('#left-back-arrow').hide();
        $('#right-front-arrow').hide();
        $('#right-back-arrow').hide();
    },
    rotateCar: function(degree){
        movement.carRotation += degree;
        $('#svg').css('transform', `rotate(${movement.carRotation}deg)`)
    },
    rotateBothFront: function(){
        movement.initiateMovement();
        $('#front-arrow').show();
        $('#left-front-arrow').show();
        $('#right-front-arrow').show();
    },
    rotateBothBack: function(){
        movement.initiateMovement();
        $('#back-arrow').show();
        $('#left-back-arrow').show();
        $('#right-back-arrow').show();
    },
    rotateLeftFront: function(){
        movement.initiateMovement();
        $('#front-arrow').show();
        $('#left-front-arrow').show();
        movement.rotateCar(movement.rotationValue);
    },
    rotateRightFront: function(){
        movement.initiateMovement();
        $('#front-arrow').show();
        $('#right-front-arrow').show();
        movement.rotateCar(-movement.rotationValue);
    },
    rotateLeftBack: function(){
        movement.initiateMovement();
        $('#back-arrow').show();
        $('#left-back-arrow').show();
        movement.rotateCar(-movement.rotationValue);
    },
    rotateRightBack: function(){
        movement.initiateMovement();
        $('#back-arrow').show();
        $('#right-back-arrow').show();
        movement.rotateCar(movement.rotationValue);
    },
    stopRotation: function(){
        movement.initiateMovement();
    }
};

var screen = {
    updateDisplay: function(distance){
        let color = "green";
        if(distance < 31){
            color = "red";
        }
        $('#distance')
            .css('background', color)
            .text(distance + "cm");
    }
};

function connectToWebsocket () {
    // if user is running mozilla then use it's built-in WebSocket
    window.WebSocket = window.WebSocket || window.MozWebSocket;
  
    var connection = new WebSocket('ws://127.0.0.1:3001');
  
    connection.onopen = function () {
      // connection is opened and ready to use
    };
  
    connection.onerror = function (error) {
      // an error occurred when sending/receiving data
    };
  
    connection.onmessage = function (message) {
      // try to decode json (I assume that each message
      // from server is json)
      try {
        var json = JSON.parse(message.data);
        if(json.type == "distance"){
            screen.updateDisplay(json.value);
        }else if(json.type == "wheels"){
            if(json.value == 1){
                movement.rotateBothFront();
            }else if(json.value == 2){
                movement.rotateBothBack();
            }else if(json.value == 3){
                movement.stopRotation();
            }else if(json.value == 4){
                movement.rotateLeftFront();
            }else if(json.value == 5){
                movement.rotateLeftBack();
            }else if(json.value == 6){
                movement.rotateRightFront();
            }else{
                movement.rotateRightBack();
            }
        }else{
            console.log("Connection established");
        }
        console.log(json);
      } catch (e) {
        console.log('This doesn\'t look like a valid JSON: ',
            message.data);
        return;
      }
      // handle incoming message
    };
};