var createError = require('http-errors');
var express = require('express');
var path = require('path');
var cookieParser = require('cookie-parser');
var logger = require('morgan');
var connection = require('./connection');
var messages = require('./messagesTypes');
var messagesTypes = messages.messagesTypes;
var wheelsMessagesTypes = messages.wheelsMessagesTypes;


const SerialPort = require('serialport');
const Readline = require('@serialport/parser-readline');

var indexRouter = require('./routes/index');
var usersRouter = require('./routes/users');

var app = express();

// view engine setup
app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'hbs');

app.use(logger('dev'));
app.use(express.json());
app.use(express.urlencoded({ extended: false }));
app.use(cookieParser());
app.use(express.static(path.join(__dirname, 'public')));

app.use('/', indexRouter);
app.use('/users', usersRouter);

// catch 404 and forward to error handler
app.use(function(req, res, next) {
  next(createError(404));
});

// error handler
app.use(function(err, req, res, next) {
  // set locals, only providing error in development
  res.locals.message = err.message;
  res.locals.error = req.app.get('env') === 'development' ? err : {};

  // render the error page
  res.status(err.status || 500);
  res.render('error');
});

// Connexion avec l'arduino
app.arduinoConnection = [];   // un tableau pour stocker les messages récus depuis l'Arduino
try{
  const port = new SerialPort('/dev/ttyACM0', { baudRate: 9600 });  // Ouvrir le port série
  const parser = port.pipe(new Readline({ delimiter: '\n' }));
  port.on("open", () => {
    console.log('serial port open');
  });
  // Evenement exécuté lors du lecteur des données depuis le câble
  parser.on('data', data =>{
    let message = {};
    // Si le message commence par "distance: " donc c'est suivi par un nombre qui est la distance
    if(data.substring(0,( `${messagesTypes.distance}: `).length) == `${messagesTypes.distance}: `){
      let distance = parseInt(data.substring((`${messagesTypes.distance}: `).length));
      message = {
        type: messagesTypes.distance,
        value: distance
      };
    // Si le messqge commence par "wheels: " donc c'est suivi par un nombre qui représente la roue/les roues qui tourne/ent et sa/leur direction
    }else if(data.substring(0,(`${messagesTypes.wheels}: `).length) == `${messagesTypes.wheels}: `){
      let wheels = parseInt(data.substring((`${messagesTypes.wheels}: `).length));
      message = {
        type: messagesTypes.wheels,
        value: wheels
      };
    }
    // Ajout ce message au tableau
    app.arduinoConnection.push(message);
  }); 
}catch(exp){
  console.log(exp.message);
}
module.exports = app;
