<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ApiResource(collectionOperations={
 *      "get",
 *      "prixmoyens"={
 *      "method"="GET",
 *      "openapi_context"={
 *                  "summary"="Obtient la moyenne du prix du mètre carré pour l'année et le mois sélectionnés",
 *                  "produces"={
 *                      "application/json"
 *                  },
 *                  "responses"={
 *                      "200"={
 *                          "description"="Moyenne du prix au mètre carré",
 *                          "content"= {
 *                              "application/json"={
 *                                  "schema"={
 *                                      "type"="array",
 *                                      "items"={
 *                                          "type"="object",
 *                                          "properties"={
 *                                              "annee"={
 *                                                  "type"="number"
 *                                              },
 *                                              "mois"={
 *                                                  "type"="number"
 *                                              },
 *                                              "prix_moyen_m_carree"={
 *                                                  "type"="number"
 *                                              }
 *                                          }
 *                                      }
 *                                  }
 *                              }
 *                          }
 *                      }
 *                  }
 *              },
 *         "route_name"="prix_moyens",
 *         "controller"=PrixMoyenParAnnee::class,
 *         "pagination_enabled"=false,
 *     },
 *  "nombredeventeparJMA"={
 *      "method"="GET",
 *      "openapi_context"={
 *             "read"=false,
 *              "parameters"={
 *                  {
 *                      "in"="query",
 *                      "name"="interval",
 *                      "required"= true,
 *                      "schema"= {
 *                          "type"="string",
 *                          "enum"={"day","month","year"}
 *                      },
 *                      "example"="day"
 *                  },
 *                  {
 *                      "in"="query",
 *                      "name"="dateDebut",
 *                      "required"= true,
 *                      "schema"= {
 *                          "type"="string",
 *                          "format"="full-date"
 *                      },
 *                      "example"="2015-01-01"
 *                  },
 *                  {
 *                      "in"="query",
 *                      "name"="dateFin",
 *                      "required"= true,
 *                      "schema"= {
 *                          "type"="string",
 *                          "format"="full-date"
 *                      },
 *                      "example"="2015-02-01"
 *                  }
 *              }
 *           },
 *         "route_name"="nombre_devente_parJMA",
 *         "controller"=NombreDeVenteParJMA::class,
 *         "pagination_enabled"=false,
 *       }
 * })
 * @ORM\Entity(repositoryClass="App\Repository\ValeursFonciereRepository")
 */
class ValeursFonciere
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="date")
     */
    private $date_mutation;

    /**
     * @ORM\Column(type="string")
     */
    private $nature_mutation;

    /**
     * @ORM\Column(type="float")
     */
    private $valeur_fonciere;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $commune;

    /**
     * @ORM\Column(type="integer")
     */
    private $code_commune;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $type_local;

    /**
     * @ORM\Column(type="integer")
     */
    private $code_type_local;

    /**
     * @ORM\Column(type="float")
     */
    private $surface_reelle_bati;

    /**
     * @ORM\Column(type="integer")
     */
    private $code_departement;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDateMutation(): ?\DateTimeInterface
    {
        return $this->date_mutation;
    }

    public function setDateMutation(\DateTimeInterface $date_mutation): self
    {
        $this->date_mutation = $date_mutation;

        return $this;
    }

    public function getNatureMutation(): ?string
    {
        return $this->nature_mutation;
    }

    public function setNatureMutation(string $nature_mutation): self
    {
        $this->nature_mutation = $nature_mutation;

        return $this;
    }

    public function getValeurFonciere(): ?float
    {
        return $this->valeur_fonciere;
    }

    public function setValeurFonciere(float $valeur_fonciere): self
    {
        $this->valeur_fonciere = $valeur_fonciere;

        return $this;
    }

    public function getCommune(): ?string
    {
        return $this->commune;
    }

    public function setCommune(string $commune): self
    {
        $this->commune = $commune;

        return $this;
    }

    public function getCodeCommune(): ?int
    {
        return $this->code_commune;
    }

    public function setCodeCommune(int $code_commune): self
    {
        $this->code_commune = $code_commune;

        return $this;
    }

    public function getTypeLocal(): ?string
    {
        return $this->type_local;
    }

    public function setTypeLocal(string $type_local): self
    {
        $this->type_local = $type_local;

        return $this;
    }

    public function getCodeTypeLocal(): ?int
    {
        return $this->code_type_local;
    }

    public function setCodeTypeLocal(int $code_type_local): self
    {
        $this->code_type_local = $code_type_local;

        return $this;
    }

    public function getSurfaceReelleBati(): ?float
    {
        return $this->surface_reelle_bati;
    }

    public function setSurfaceReelleBati(float $surface_reelle_bati): self
    {
        $this->surface_reelle_bati = $surface_reelle_bati;

        return $this;
    }

    public function getCodeDepartement(): ?int
    {
        return $this->code_departement;
    }

    public function setCodeDepartement(int $code_departement): self
    {
        $this->code_departement = $code_departement;

        return $this;
    }
}
