<?php

namespace App\DataFixtures;
use App\Entity\ValeursFonciere;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\Persistence\ObjectManager;
use League\Csv\Reader;
use League\Csv\Statement;

class AppFixtures extends Fixture
{
    public function load(ObjectManager $manager)
    {
        // $product = new Product();
        // $manager->persist($product);

        for($annee= 5; $annee<10; $annee++){
            var_dump("Chargement des donnees de 201".$annee);
            $reader = Reader::createFromPath('%kernel.root_dir%/../src/Data/valeursfoncieres-201'.$annee.'.txt');
            $reader->setDelimiter("|");
            $reader->setHeaderOffset(0);
            $manager->getConnection()->getConfiguration()->setSQLLogger(null);
            $stmt = (new Statement())->offset(0);
            $results = $stmt->process($reader);
            $numItemsLoaded = 0;
            //$results = $reader->fetchAssoc();
            // $valeur_fonc = new ValeursFonciere();
            // $manager->persist($valeur_fonc);
            // create 20 products! Bam!
            foreach ($results as $row) {
              if($row['Code type local']== 1 || $row['Code type local']==2){
                $valeur_fonc = new ValeursFonciere();
                $valeur_fonc->setDateMutation(\DateTime::createFromFormat("d/m/Y", $row["Date mutation"]));
                $valeur_fonc->setNatureMutation($row['Nature mutation']);
                $valeur_fonc->setValeurFonciere(floatval(str_replace(',', '.', $row['Valeur fonciere'])));
                $valeur_fonc->setCommune($row['Commune']);
                $valeur_fonc->setCodeCommune(intval(str_replace(',', '.', $row['Code commune'])));
                $valeur_fonc->setCodeTypeLocal(intval(str_replace(',', '.', $row['Code type local'])));
                $valeur_fonc->setCodeDepartement(intval(str_replace(',', '.', $row['Code departement'])));
                $valeur_fonc->setTypeLocal($row['Type local']);
                $valeur_fonc->setSurfaceReelleBati(floatval(str_replace(',', '.', $row['Surface reelle bati'])));
                $manager->persist($valeur_fonc);
                $numItemsLoaded++;
               
                if($numItemsLoaded === 99){
                    $numItemsLoaded = 0;
                    $manager->flush();
                    $manager->clear();
                }
             }
            }
            $manager->flush();
            $manager->clear();
        }
    }
}
