<?php

namespace App\Controller;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @Route("/prix_moyens", name="prix_moyens")
 */

class PrixMoyenParAnnee extends AbstractController{
  /**
     * Entity Manager
     */
    private $em;
    /**
     * Creates a new instance of GetMeanPricesByYear
     */
    public function __construct(EntityManagerInterface $em) {
        $this->em = $em;
    }
    public function __invoke() { 
       
        $query = "  SELECT
                        TO_CHAR(valeurs_fonciere.date_mutation, 'YYYY') AS annee,
                        TO_CHAR(valeurs_fonciere.date_mutation, 'MM') AS mois,
                        AVG(valeurs_fonciere.valeur_fonciere / valeurs_fonciere.surface_reelle_bati) AS prix_moyen_m_carree
                    FROM
                        App:ValeursFonciere AS valeurs_fonciere
                    WHERE
                        valeurs_fonciere.surface_reelle_bati > 0
                        AND
                        valeurs_fonciere.valeur_fonciere > 0
                        AND
                        lower(valeurs_fonciere.nature_mutation) = 'vente'
                    GROUP BY 
                        annee,
                        mois
                    ORDER BY
                        annee,
                        mois";
        $prix_mettres = $this->em->createQuery($query)->getResult();
        foreach ($prix_mettres as &$prix_mettre){
            $prix_mettre['annee'] = intval($prix_mettre['annee']);
            $prix_mettre['mois'] = intval($prix_mettre['mois']);
            $prix_mettre['prix_moyen_m_carree'] = floatval($prix_mettre['prix_moyen_m_carree']);
        }
        $res = new JsonResponse(
            $prix_mettres,
            Response::HTTP_OK
        );
        return $res;
    }
}