<?php

namespace App\Controller;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @Route("/nombre_devente_parJMA", name="nombre_devente_parJMA")
 */

class  NombreDeVenteParJMA extends AbstractController{
  /**
     * Entity Manager
     */
    private $em;
    /**
     * Creates a new instance of NombreDeVenteParJMA
     */
    public function __construct(EntityManagerInterface $em) {
        $this->em = $em;
    }
    
    public function __invoke(Request $data) { 
       // $date1 = '05/06/2015';
       // $date1 = '05/06/2016';
        $date1 = $data->query->get('dateDebut');
        $date2 = $data->query->get('dateFin');
        $interval = $data->query->get('interval');
       // DATE_FORMAT("2017-06-15", "%Y");
        $query = "  SELECT
                        COUNT(valeurs_fonciere.nature_mutation) AS nombre_de_vente,
                        DATE_TRUNC('$interval', valeurs_fonciere.date_mutation) AS dat
                    FROM
                        App:ValeursFonciere AS valeurs_fonciere
                    WHERE
                        lower(valeurs_fonciere.nature_mutation) = 'vente'
                        AND
                        valeurs_fonciere.date_mutation BETWEEN '$date1'  AND '$date2'
                    GROUP BY 
                    dat
                   ORDER BY
                    dat";
                
                    
        $nombreVentes = $this->em->createQuery($query)->getResult();
        foreach ($nombreVentes as &$nombreVente){
            $nombreVente['nombre_de_vente'] = intval($nombreVente['nombre_de_vente']);
            $nombreVente['dat'] =  $nombreVente["dat"];
        }
        $res = new JsonResponse(
            $nombreVentes,
            Response::HTTP_OK
        );
        return $res;
    }
}