const express = require('express');
const app = express()
const expressWs = require('express-ws')(app);

const PORT = 18888;
const websocket_connections = {};
const tabRep = [];

const server = app.listen(PORT, () => {
    console.log(`App listening at http://localhost:${PORT}`);
    console.log(`WebSocket listening at ws://localhost:${PORT}`);
});

app.ws('/client', (ws, req) => {
    ws.on('message', (msg) => {
        switch (msg) {
            case "lent":
            	ws.send("test");
                break;
            case "normal":
                break;
            case "rapide":
                break;
            case "donnerRequete":
            	if(tabRep.length){
            	    ws.send(tabRep[0]);
            	}
                break;
            default:
            	for(const [ip,ws] of Object.entries(websocket_connections)) {
            	    ws.send("search "+msg+" a 9999");
            	}
                break;
        }
    });
});


app.ws('/slave', (ws, req) => {
    const client_ip = req.connection.remoteAddress;
    websocket_connections[client_ip] = ws;
    
    ws.on('message', (msg) => {
        if(msg.startsWith("found"))
        {
            tabRep.push(msg.split(" ")[1]+ " = "+msg.split(" ")[2])
        }
    });
});
