/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.util;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FibonacciHeap<K extends Comparable<K>, V> {
    protected Node min = null;
    protected int size = 0;
    protected ArrayList<Node> degList = new ArrayList();

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        if (!this.isEmpty()) {
            this.min.clear();
            this.min = null;
            this.size = 0;
        }
    }

    public Node add(K key, V value) {
        Node node = new Node(this, key, value);
        if (this.isEmpty()) {
            this.min = node;
        } else {
            this.min.concatLists(node);
            if (node.key.compareTo(this.min.key) < 0) {
                this.min = node;
            }
        }
        ++this.size;
        return node;
    }

    public void addAll(FibonacciHeap<K, V> heap) {
        if (this.isEmpty()) {
            this.min = heap.min;
        } else if (!heap.isEmpty()) {
            this.min.concatLists(heap.min);
            if (heap.min.key.compareTo(this.min.key) < 0) {
                this.min = heap.min;
            }
        }
        this.size += heap.size;
        heap.min = null;
        heap.size = 0;
    }

    public K getMinKey() {
        return this.min.key;
    }

    public V getMinValue() {
        return this.min.value;
    }

    public V extractMin() {
        Node z = this.min;
        Node x = z.child;
        if (x != null) {
            do {
                x.parent = null;
            } while ((x = x.right) != z.child);
            z.concatLists(x);
            z.child = null;
        }
        if (z == z.right) {
            this.min = null;
        } else {
            z.left.right = z.right;
            z.right.left = z.left;
            this.min = z.right;
            this.consolidate();
        }
        z.right = null;
        z.left = null;
        --this.size;
        return z.value;
    }

    protected void consolidate() {
        Node w = this.min;
        this.degList.clear();
        do {
            Node x = w;
            w = w.right;
            int d = x.degree;
            while (d >= this.degList.size()) {
                this.degList.add(null);
            }
            Node y = this.degList.get(d);
            while (y != null) {
                if (x.key.compareTo(y.key) > 0) {
                    Node t = x;
                    x = y;
                    y = t;
                }
                x.addChild(y);
                this.degList.set(d, null);
                if (++d >= this.degList.size()) {
                    this.degList.add(null);
                }
                y = this.degList.get(d);
            }
            this.degList.set(d, x);
        } while (w != this.min);
        this.min = null;
        for (Node s : this.degList) {
            if (s == null) continue;
            s.left = s.right = s;
            if (this.min == null) {
                this.min = s;
                continue;
            }
            this.min.concatLists(s);
            if (s.key.compareTo(this.min.key) >= 0) continue;
            this.min = s;
        }
    }

    public void decreaseKey(Node x, K key) {
        if (key.compareTo(x.key) > 0) {
            throw new IllegalArgumentException("The new key must be less than the old");
        }
        x.key = key;
        Node y = x.parent;
        if (y != null && x.key.compareTo(y.key) < 0) {
            this.detach(x);
            this.multiDetach(y);
        }
        if (key.compareTo(this.min.key) < 0) {
            this.min = x;
        }
    }

    protected void detach(Node x) {
        Node y = x.parent;
        --y.degree;
        if (x == x.right) {
            y.child = null;
        } else {
            x.left.right = x.right;
            x.right.left = x.left;
            if (y.child == x) {
                y.child = x.right;
            }
            x.left = x.right = x;
        }
        this.min.concatLists(x);
        x.parent = null;
        x.lostChild = false;
    }

    protected void multiDetach(Node x) {
        if (x.parent == null) {
            return;
        }
        if (x.lostChild) {
            Node z = x.parent;
            this.detach(x);
            this.multiDetach(z);
        } else {
            x.lostChild = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node {
        protected K key;
        protected V value;
        protected Node parent;
        protected Node child;
        protected Node left;
        protected Node right;
        protected int degree;
        protected boolean lostChild;
        final /* synthetic */ FibonacciHeap this$0;

        protected Node(K key, V value) {
            this.this$0 = var1_1;
            this.key = key;
            this.value = value;
            this.child = null;
            this.parent = null;
            this.left = this.right = this;
            this.degree = 0;
            this.lostChild = false;
        }

        protected void clear() {
            this.parent = null;
            if (this.child != null) {
                this.child.clear();
                this.child = null;
            }
            this.left.right = null;
            this.left = null;
            if (this.right != null) {
                this.right.clear();
            }
        }

        protected void concatLists(Node y) {
            Node r = this.right;
            Node l = y.left;
            this.right = y;
            y.left = this;
            l.right = r;
            r.left = l;
        }

        protected void addChild(Node y) {
            y.parent = this;
            y.left = y.right = y;
            y.lostChild = false;
            ++this.degree;
            if (this.child == null) {
                this.child = y;
            } else {
                this.child.concatLists(y);
            }
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

