/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import org.graphstream.algorithm.DynamicAlgorithm;
import org.graphstream.algorithm.measure.ChartSeries2DMeasure;
import org.graphstream.graph.Graph;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SinkAdapter;

public abstract class ElementCountMeasure
extends ChartSeries2DMeasure
implements DynamicAlgorithm {
    protected Graph g;
    private Sink trigger = new StepTrigger();

    protected ElementCountMeasure(String name) {
        super(name);
    }

    public abstract double getElementCount();

    public void terminate() {
        this.g.removeSink(this.trigger);
        this.g = null;
    }

    public void compute() {
        this.addValue(this.g.getStep(), this.getElementCount());
    }

    public void init(Graph graph) {
        this.g = graph;
        this.g.addSink(this.trigger);
    }

    private class StepTrigger
    extends SinkAdapter {
        private StepTrigger() {
        }

        public void stepBegins(String sourceId, long timeId, double step) {
            ElementCountMeasure.this.compute();
        }
    }

    public static class EdgeCountMeasure
    extends ElementCountMeasure {
        public EdgeCountMeasure() {
            super("edges");
        }

        public EdgeCountMeasure(String name) {
            super(name);
        }

        public double getElementCount() {
            return this.g.getEdgeCount();
        }
    }

    public static class NodeCountMeasure
    extends ElementCountMeasure {
        public NodeCountMeasure() {
            super("nodes");
        }

        public NodeCountMeasure(String name) {
            super(name);
        }

        public double getElementCount() {
            return this.g.getNodeCount();
        }
    }
}

