/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import java.util.Arrays;
import org.graphstream.algorithm.measure.AbstractCentrality;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;

public class EigenvectorCentrality
extends AbstractCentrality {
    public static final String DEFAULT_ATTRIBUTE_KEY = "eigenvector";
    public static final int DEFAULT_MAX_ITER = 100;
    protected int maxIter;
    protected String weightAttribute;

    public EigenvectorCentrality() {
        this("DEFAULT_ATTRIBUTE_KEY", AbstractCentrality.NormalizationMode.NONE);
    }

    public EigenvectorCentrality(String attribute, AbstractCentrality.NormalizationMode normalize) {
        this(attribute, normalize, 100, "weight");
    }

    public EigenvectorCentrality(String attribute, AbstractCentrality.NormalizationMode normalize, int maxIter, String weightAttribute) {
        super(attribute, normalize);
        this.maxIter = maxIter;
        this.weightAttribute = weightAttribute;
    }

    protected void computeCentrality() {
        int n = this.graph.getNodeCount();
        double[] x1 = new double[n];
        double[] x2 = new double[n];
        int iter = this.maxIter;
        Arrays.fill(x2, 1.0 / (double)n);
        while (iter-- > 0) {
            int idx;
            double[] t = x1;
            x1 = x2;
            x2 = t;
            Arrays.fill(x2, 0.0);
            double s = 0.0;
            for (idx = 0; idx < n; ++idx) {
                Node node = this.graph.getNode(idx);
                for (int i = 0; i < node.getDegree(); ++i) {
                    Edge edge = node.getEdge(i);
                    double f = 1.0;
                    if (edge.hasNumber(this.weightAttribute)) {
                        f = edge.getNumber(this.weightAttribute);
                    }
                    int n2 = idx;
                    x2[n2] = x2[n2] + x1[edge.getOpposite(node).getIndex()] * f;
                }
                s += x2[idx] * x2[idx];
            }
            s = s == 0.0 ? 1.0 : 1.0 / Math.sqrt(s);
            idx = 0;
            while (idx < n) {
                int n3 = idx++;
                x2[n3] = x2[n3] * s;
            }
        }
        this.data = x2;
    }
}

