/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import org.graphstream.algorithm.measure.AbstractCentrality;

public class DegreeCentrality
extends AbstractCentrality {
    public static final String DEFAULT_ATTRIBUTE_KEY = "degree";
    protected Mode mode;

    public DegreeCentrality() {
        this(DEFAULT_ATTRIBUTE_KEY, AbstractCentrality.NormalizationMode.NONE);
    }

    public DegreeCentrality(String attribute, AbstractCentrality.NormalizationMode normalize) {
        this(attribute, normalize, Mode.INOUT);
    }

    public DegreeCentrality(String attribute, AbstractCentrality.NormalizationMode normalize, Mode mode) {
        super(attribute, normalize);
        this.mode = mode;
    }

    protected void computeCentrality() {
        int count = this.graph.getNodeCount();
        switch (this.mode) {
            case INOUT: {
                for (int idx = 0; idx < count; ++idx) {
                    this.data[idx] = this.graph.getNode(idx).getDegree();
                }
                break;
            }
            case IN: {
                for (int idx = 0; idx < count; ++idx) {
                    this.data[idx] = this.graph.getNode(idx).getInDegree();
                }
                break;
            }
            case OUT: {
                for (int idx = 0; idx < count; ++idx) {
                    this.data[idx] = this.graph.getNode(idx).getOutDegree();
                }
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        INOUT,
        IN,
        OUT;

    }
}

