/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import java.util.HashMap;
import java.util.HashSet;
import org.graphstream.algorithm.DynamicAlgorithm;
import org.graphstream.algorithm.Toolkit;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SinkAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommunityMeasure
extends SinkAdapter
implements DynamicAlgorithm {
    protected Graph graph;
    protected String marker;
    protected HashMap<Object, HashSet<Node>> communities;
    protected boolean graphChanged = true;
    protected double M;

    public CommunityMeasure(String marker) {
        this.marker = marker;
    }

    public double getLastComputedValue() {
        return this.M;
    }

    public double getMeasure() {
        this.compute();
        return this.M;
    }

    @Override
    public void init(Graph graph) {
        if (graph != this.graph) {
            if (this.graph != null) {
                this.graph.removeSink((Sink)this);
            }
            this.graph = graph;
            if (this.graph != null) {
                this.graph.addSink((Sink)this);
                this.initialize();
            }
        }
    }

    @Override
    public abstract void compute();

    @Override
    public void terminate() {
    }

    protected void initialize() {
        this.communities = Toolkit.communities(this.graph, this.marker);
    }

    public void nodeAdded(String graphId, long timeId, String nodeId) {
        Node n = this.graph.getNode(nodeId);
        this.assignNode(nodeId, n.getAttribute(this.marker), this.communities);
    }

    public void nodeRemoved(String graphId, long timeId, String nodeId) {
        Node n = this.graph.getNode(nodeId);
        this.unassignNode(nodeId, n.getAttribute(this.marker), this.communities);
    }

    public void edgeAdded(String graphId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.graphChanged = true;
    }

    public void edgeRemoved(String graphId, long timeId, String edgeId) {
        this.graphChanged = true;
    }

    public void graphCleared(String graphId, long timeId) {
        this.graphChanged = true;
    }

    public void nodeAttributeAdded(String graphId, long timeId, String nodeId, String attribute, Object value) {
        this.nodeAttributeChanged(graphId, timeId, nodeId, attribute, null, value);
    }

    public void nodeAttributeChanged(String graphId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        if (attribute.equals(this.marker) && oldValue != newValue) {
            this.unassignNode(nodeId, oldValue, this.communities);
            this.assignNode(nodeId, newValue, this.communities);
        }
    }

    protected void assignNode(String nodeId, Object newValue, HashMap<Object, HashSet<Node>> assignment) {
        Node node = this.graph.getNode(nodeId);
        if (node != null) {
            HashSet<Object> community;
            Object communityKey = newValue;
            if (communityKey == null) {
                communityKey = "NULL_COMMUNITY";
            }
            if ((community = assignment.get(communityKey)) == null) {
                community = new HashSet();
                assignment.put(communityKey, community);
            }
            community.add(node);
            this.graphChanged = true;
        }
    }

    protected void unassignNode(String nodeId, Object oldValue, HashMap<Object, HashSet<Node>> assignment) {
        Node node = this.graph.getNode(nodeId);
        if (node != null) {
            Object communityKey = oldValue;
            if (communityKey == null) {
                communityKey = "NULL_COMMUNITY";
            }
            HashSet<Node> community = assignment.get(communityKey);
            assert (community != null) : "Removing a node that was not placed in any community !!";
            if (community != null) {
                community.remove(node);
                if (community.size() == 0) {
                    assignment.remove(communityKey);
                }
            }
            this.graphChanged = true;
        }
    }
}

