/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import org.graphstream.algorithm.APSP;
import org.graphstream.algorithm.measure.AbstractCentrality;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

public class ClosenessCentrality
extends AbstractCentrality {
    public static final String DEFAULT_ATTRIBUTE_KEY = "closeness";
    protected boolean computeAPSP;
    protected boolean useDangalchevMethod = false;
    private APSP apsp;

    public ClosenessCentrality() {
        this(DEFAULT_ATTRIBUTE_KEY);
    }

    public ClosenessCentrality(String attribute) {
        this(attribute, AbstractCentrality.NormalizationMode.NONE);
    }

    public ClosenessCentrality(String attribute, AbstractCentrality.NormalizationMode normalize) {
        this(attribute, normalize, true, false);
    }

    public ClosenessCentrality(String centralityAttribute, AbstractCentrality.NormalizationMode normalize, boolean computeAPSP, boolean useDangalchevMethod) {
        super(centralityAttribute, normalize);
        this.computeAPSP = computeAPSP;
        this.useDangalchevMethod = useDangalchevMethod;
    }

    public void init(Graph graph) {
        super.init(graph);
        if (this.computeAPSP) {
            this.apsp = new APSP();
            this.apsp.init(graph);
        }
    }

    protected void computeCentrality() {
        int count = this.graph.getNodeCount();
        if (this.computeAPSP) {
            this.apsp.compute();
        }
        for (int idx = 0; idx < count; ++idx) {
            Node node = this.graph.getNode(idx);
            this.data[idx] = 0.0;
            APSP.APSPInfo info = (APSP.APSPInfo)node.getAttribute("APSPInfo");
            if (info == null) {
                System.err.printf("APSPInfo missing. Did you compute APSP before ?\n", new Object[0]);
            }
            for (int idx2 = 0; idx2 < count; ++idx2) {
                if (idx == idx2) continue;
                Node other = this.graph.getNode(idx2);
                double d = info.getLengthTo(other.getId());
                if (this.useDangalchevMethod) {
                    int n = idx;
                    this.data[n] = this.data[n] + Math.pow(2.0, -d);
                    continue;
                }
                if (d < 0.0) {
                    System.err.printf("Found a negative length value in centroid algorithm. Is graph connected ?\n", new Object[0]);
                    continue;
                }
                int n = idx;
                this.data[n] = this.data[n] + d;
            }
            if (this.useDangalchevMethod) continue;
            this.data[idx] = 1.0 / this.data[idx];
        }
    }
}

