/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import java.net.URISyntaxException;
import org.graphstream.algorithm.generator.URLGenerator;

public class WikipediaGenerator
extends URLGenerator {
    public static final String SPECIAL_URLS = "^https://%s[.]wikipedia[.]org/wiki/(Wikipedia|File|Special|Category|Talk|Portal|Help|Template|Template_talk):.*$";
    protected final Lang lang;

    public WikipediaGenerator(String ... articles) {
        this(Lang.EN, articles);
    }

    public WikipediaGenerator(Lang lang, String ... articles) {
        super(new String[0]);
        this.lang = lang;
        this.setDirected(true);
        this.setMode(URLGenerator.Mode.PATH);
        this.addHostFilter(lang.host);
        this.declineMatchingURL("^https?://" + lang.host + "/wiki/index.php.*");
        this.declineMatchingURL("^https?://" + lang.host + "/wiki/" + lang.mainPage);
        this.declineMatchingURL("^https?://" + lang.host + "/wiki/[\\w_]+:.*$");
        this.acceptOnlyMatchingURL("^https?://" + lang.host + "/wiki/.*$");
        if (articles != null) {
            for (int i = 0; i < articles.length; ++i) {
                this.addArticle(articles[i]);
            }
        }
    }

    public void addArticle(String name) {
        this.addURL("https://" + this.lang.host + "/wiki/" + name);
    }

    protected String getNodeLabel(String url) throws URISyntaxException {
        return url.substring(url.indexOf("/wiki/") + 6);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Lang {
        EN("en.wikipedia.org", "Main_Page", "Wikipedia|File|Special|Category|Talk|Portal|Help|Template|Template_talk"),
        FR("fr.wikipedia.org", "Wikip\u00e9dia:Accueil_Principal", "Wikip\u00e9dia|Aide|Sp\u00e9cial|Cat\u00e9gorie|Portail|Discussion|Special");

        final String host;
        final String mainPage;
        final String specialFiles;

        private Lang(String host, String mainPage, String special) {
            this.host = host;
            this.mainPage = mainPage;
            this.specialFiles = special;
        }
    }
}

