/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.graphstream.algorithm.generator.BaseGenerator;
import org.graphstream.algorithm.util.RandomTools;

public class RandomGenerator
extends BaseGenerator {
    protected double averageDegree;
    protected boolean allowRemove;
    protected List<String> edgeIds;
    protected Set<Integer> subset;
    protected int nodeCount;

    public RandomGenerator() {
        this(1.0, true, false);
    }

    public RandomGenerator(double averageDegree) {
        this(averageDegree, true, false);
    }

    public RandomGenerator(double averageDegree, boolean allowRemove) {
        this(averageDegree, allowRemove, false);
    }

    public RandomGenerator(double averageDegree, boolean allowRemove, boolean directed) {
        super(directed, true);
        this.init(averageDegree, allowRemove);
    }

    public RandomGenerator(double averageDegree, boolean allowRemove, boolean directed, String nodeAttribute, String edgeAttribute) {
        super(directed, true, nodeAttribute, edgeAttribute);
        this.init(averageDegree, allowRemove);
    }

    public void begin() {
        if (this.allowRemove) {
            this.edgeIds = new ArrayList<String>();
        }
        this.subset = new HashSet<Integer>();
        this.nodeCount = 0;
        while (this.nodeCount <= (int)this.averageDegree) {
            this.addNode(this.nodeCount + "");
            ++this.nodeCount;
        }
        for (int i = 0; i < this.nodeCount; ++i) {
            for (int j = i + 1; j < this.nodeCount; ++j) {
                String edgeId = i + "_" + j;
                this.addEdge(edgeId, i + "", j + "");
                if (!this.allowRemove) continue;
                this.edgeIds.add(edgeId);
            }
        }
    }

    public boolean nextEvents() {
        double addProbability = this.averageDegree / (double)this.nodeCount;
        if (this.allowRemove) {
            this.removeExistingEdges(1.0 / (double)this.nodeCount);
        } else {
            addProbability /= 2.0;
        }
        this.addNode(this.nodeCount + "");
        this.addNewEdges(addProbability);
        ++this.nodeCount;
        return true;
    }

    public void end() {
        super.end();
        if (this.allowRemove) {
            this.edgeIds.clear();
            this.edgeIds = null;
        }
        this.subset.clear();
        this.subset = null;
    }

    protected void init(double averageDegree, boolean allowRemove) {
        if (averageDegree < 0.0) {
            throw new IllegalArgumentException("The average degree must be non negative");
        }
        this.averageDegree = averageDegree;
        this.allowRemove = allowRemove;
    }

    protected void addNewEdges(double p) {
        RandomTools.randomPsubset(this.nodeCount, p, this.subset, this.random);
        String nodeId = this.nodeCount + "";
        for (int i : this.subset) {
            String edgeId = i + "_" + nodeId;
            this.addEdge(edgeId, i + "", nodeId);
            if (!this.allowRemove) continue;
            this.edgeIds.add(edgeId);
        }
    }

    protected void removeExistingEdges(double p) {
        RandomTools.randomPsubset(this.edgeIds.size(), p, this.subset, this.random);
        int last = this.edgeIds.size() - 1;
        while (!this.subset.isEmpty()) {
            if (this.subset.contains(last)) {
                this.subset.remove(last);
                this.delEdge(this.edgeIds.get(last));
            } else {
                Iterator<Integer> it = this.subset.iterator();
                int i = it.next();
                it.remove();
                this.delEdge(this.edgeIds.get(i));
                this.edgeIds.set(i, this.edgeIds.get(last));
            }
            this.edgeIds.remove(last);
            --last;
        }
    }
}

