/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import java.util.LinkedList;
import org.graphstream.algorithm.generator.BaseGenerator;

public class LobsterGenerator
extends BaseGenerator {
    protected int maxDistance = 2;
    protected int maxDegree = 10;
    protected boolean delete = false;
    protected int averageNodeCount = 200;
    protected int currentIndex = 0;
    protected LinkedList<Data> nodes;

    public LobsterGenerator() {
        this(2, -1);
    }

    public LobsterGenerator(int maxDistance, int maxDegree) {
        this.maxDistance = maxDistance;
        this.maxDegree = maxDegree;
        this.nodes = new LinkedList();
    }

    public LobsterGenerator(int maxDistance) {
        this(maxDistance, -1);
    }

    public void begin() {
        this.nodes.clear();
        this.add(new Data(this.newNodeId(), 0, true));
    }

    public boolean nextEvents() {
        Data connectTo = null;
        do {
            connectTo = this.nodes.get(this.random.nextInt(this.nodes.size()));
        } while (connectTo.distance >= this.maxDistance || this.maxDegree > 0 && connectTo.degree() >= this.maxDegree);
        Data newData = null;
        newData = connectTo.path && connectTo.degree() <= 1 ? new Data(this.newNodeId(), 0, true) : new Data(this.newNodeId(), connectTo.distance + 1, false);
        this.add(newData);
        this.connect(connectTo, newData);
        if (this.delete && this.nodes.size() > 1) {
            double d = Math.min(this.nodes.size() - this.averageNodeCount, this.averageNodeCount / 10);
            if ((d /= (double)this.averageNodeCount / 10.0) > 0.0 && (double)this.random.nextFloat() < d) {
                Data delete = null;
                while ((delete = this.nodes.get(this.random.nextInt(this.nodes.size()))).degree() > 1) {
                }
                this.delNode(delete);
            }
        }
        return true;
    }

    protected void add(Data data) {
        this.nodes.add(data);
        this.addNode(data.id);
    }

    protected void connect(Data d1, Data d2) {
        d1.connected.add(d2);
        d2.connected.add(d1);
        this.addEdge(this.getEdgeId(d1, d2), d1.id, d2.id);
    }

    protected void delNode(Data d) {
        for (Data c : d.connected) {
            this.delEdge(this.getEdgeId(d, c));
            c.connected.remove(d);
        }
        this.delNode(d.id);
        this.nodes.remove(d);
    }

    protected String newNodeId() {
        return String.format("%04d", this.currentIndex++);
    }

    protected String getEdgeId(Data d1, Data d2) {
        if (d1.hashCode() > d2.hashCode()) {
            Data t = d1;
            d1 = d2;
            d2 = t;
        }
        return String.format("%s--%s", d1.id, d2.id);
    }

    protected static class Data {
        String id;
        int distance;
        boolean path;
        LinkedList<Data> connected;

        Data(String id, int distance, boolean path) {
            this.id = id;
            this.distance = distance;
            this.connected = new LinkedList();
            this.path = path;
        }

        int degree() {
            return this.connected.size();
        }
    }
}

