/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import java.util.HashSet;
import org.graphstream.algorithm.generator.BaseGenerator;

public class IncompleteGridGenerator
extends BaseGenerator {
    protected int currentWidth = 0;
    protected int currentHeight = 0;
    protected float holeProbability = 0.5f;
    protected int holeMaxSize = 5;
    protected int holesPerStep = 3;
    protected boolean cross = true;
    protected HashSet<String> unbreakable = new HashSet();

    public IncompleteGridGenerator() {
        this(true, 0.5f, 5, 3);
    }

    public IncompleteGridGenerator(boolean cross, float holeProbability, int holeMaxSize, int holesPerStep) {
        this.setUseInternalGraph(true);
        this.cross = cross;
        this.holeProbability = holeProbability;
        this.holeMaxSize = holeMaxSize;
        this.holesPerStep = holesPerStep;
    }

    protected String getNodeId(int x, int y) {
        return String.format("%d_%d", x, y);
    }

    protected String getEdgeId(String n1, String n2) {
        if (n1.compareTo(n2) < 0) {
            String tmp = n2;
            n2 = n1;
            n1 = tmp;
        }
        return String.format("%s-%s", n1, n2);
    }

    protected void connectNode(int x, int y) {
        String neigh;
        String nodeId = this.getNodeId(x, y);
        if (x > 0) {
            neigh = this.getNodeId(x - 1, y);
            if (this.internalGraph.getNode(neigh) != null) {
                this.addEdge(this.getEdgeId(nodeId, neigh), nodeId, neigh);
            } else {
                this.unbreakable.add(nodeId);
            }
        }
        if (x < this.currentWidth - 1) {
            neigh = this.getNodeId(x + 1, y);
            if (this.internalGraph.getNode(neigh) != null) {
                this.addEdge(this.getEdgeId(nodeId, neigh), nodeId, neigh);
            } else {
                this.unbreakable.add(nodeId);
            }
        }
        if (y > 0) {
            neigh = this.getNodeId(x, y - 1);
            if (this.internalGraph.getNode(neigh) != null) {
                this.addEdge(this.getEdgeId(nodeId, neigh), nodeId, neigh);
            } else {
                this.unbreakable.add(nodeId);
            }
        }
        if (y < this.currentHeight - 1) {
            neigh = this.getNodeId(x, y + 1);
            if (this.internalGraph.getNode(neigh) != null) {
                this.addEdge(this.getEdgeId(nodeId, neigh), nodeId, neigh);
            } else {
                this.unbreakable.add(nodeId);
            }
        }
        if (x > 0) {
            if (y > 0) {
                neigh = this.getNodeId(x - 1, y - 1);
                if (this.internalGraph.getNode(neigh) != null) {
                    if (this.cross) {
                        this.addEdge(this.getEdgeId(nodeId, neigh), nodeId, neigh);
                    }
                } else {
                    this.unbreakable.add(nodeId);
                }
            }
            if (y < this.currentHeight - 1) {
                neigh = this.getNodeId(x - 1, y + 1);
                if (this.internalGraph.getNode(neigh) != null) {
                    if (this.cross) {
                        this.addEdge(this.getEdgeId(nodeId, neigh), nodeId, neigh);
                    }
                } else {
                    this.unbreakable.add(nodeId);
                }
            }
        }
        if (x < this.currentWidth - 1) {
            if (y > 0) {
                neigh = this.getNodeId(x + 1, y - 1);
                if (this.internalGraph.getNode(neigh) != null) {
                    if (this.cross) {
                        this.addEdge(this.getEdgeId(nodeId, neigh), nodeId, neigh);
                    }
                } else {
                    this.unbreakable.add(nodeId);
                }
            }
            if (y < this.currentHeight - 1) {
                neigh = this.getNodeId(x + 1, y + 1);
                if (this.internalGraph.getNode(neigh) != null) {
                    if (this.cross) {
                        this.addEdge(this.getEdgeId(nodeId, neigh), nodeId, neigh);
                    }
                } else {
                    this.unbreakable.add(nodeId);
                }
            }
        }
    }

    protected void disconnectNode(int x, int y) {
        String neigh;
        String nodeId = this.getNodeId(x, y);
        if (x > 0 && this.internalGraph.getNode(neigh = this.getNodeId(x - 1, y)) != null) {
            this.delEdge(this.getEdgeId(nodeId, neigh));
        }
        if (x < this.currentWidth - 1 && this.internalGraph.getNode(neigh = this.getNodeId(x + 1, y)) != null) {
            this.delEdge(this.getEdgeId(nodeId, neigh));
        }
        if (y > 0 && this.internalGraph.getNode(neigh = this.getNodeId(x, y - 1)) != null) {
            this.delEdge(this.getEdgeId(nodeId, neigh));
        }
        if (y < this.currentHeight - 1 && this.internalGraph.getNode(neigh = this.getNodeId(x, y + 1)) != null) {
            this.delEdge(this.getEdgeId(nodeId, neigh));
        }
        if (this.cross) {
            if (x > 0) {
                if (y > 0 && this.internalGraph.getNode(neigh = this.getNodeId(x - 1, y - 1)) != null) {
                    this.delEdge(this.getEdgeId(nodeId, neigh));
                }
                if (y < this.currentHeight - 1 && this.internalGraph.getNode(neigh = this.getNodeId(x - 1, y + 1)) != null) {
                    this.delEdge(this.getEdgeId(nodeId, neigh));
                }
            }
            if (x < this.currentWidth - 1) {
                if (y > 0 && this.internalGraph.getNode(neigh = this.getNodeId(x + 1, y - 1)) != null) {
                    this.delEdge(this.getEdgeId(nodeId, neigh));
                }
                if (y < this.currentHeight - 1 && this.internalGraph.getNode(neigh = this.getNodeId(x + 1, y + 1)) != null) {
                    this.delEdge(this.getEdgeId(nodeId, neigh));
                }
            }
        }
    }

    public void begin() {
    }

    public boolean nextEvents() {
        int i;
        for (i = 0; i < this.currentWidth; ++i) {
            this.addNode(this.getNodeId(i, this.currentHeight), i, this.currentHeight);
            this.connectNode(i, this.currentHeight);
        }
        for (i = 0; i < this.currentHeight; ++i) {
            this.addNode(this.getNodeId(this.currentWidth, i), this.currentWidth, i);
            this.connectNode(this.currentWidth, i);
        }
        this.addNode(this.getNodeId(this.currentWidth, this.currentHeight), this.currentWidth, this.currentHeight);
        this.connectNode(this.currentWidth, this.currentHeight);
        ++this.currentWidth;
        ++this.currentHeight;
        for (int k = 0; k < this.holesPerStep; ++k) {
            int y1;
            int x1;
            if (!(this.random.nextFloat() < this.holeProbability)) continue;
            int t = 0;
            while ((this.internalGraph.getNode(this.getNodeId(x1 = this.random.nextInt(this.currentWidth), y1 = this.random.nextInt(this.currentHeight))) == null || this.unbreakable.contains(this.getNodeId(x1, y1))) && ++t < this.internalGraph.getNodeCount()) {
            }
            if (t >= this.internalGraph.getNodeCount()) continue;
            int sizeX = this.random.nextInt(this.holeMaxSize);
            int sizeY = this.random.nextInt(this.holeMaxSize - sizeX);
            for (int i2 = 0; i2 < sizeX; ++i2) {
                for (int j = 0; j < sizeY; ++j) {
                    String id = this.getNodeId(x1 + i2, y1 + j);
                    if (this.internalGraph.getNode(id) == null || this.unbreakable.contains(id)) continue;
                    this.disconnectNode(x1 + i2, y1 + j);
                    this.delNode(this.getNodeId(x1 + i2, y1 + j));
                    if (j == 0 && y1 > 0) {
                        this.unbreakable.add(this.getNodeId(x1 + i2, y1 - 1));
                    }
                    if (j == sizeY - 1 && y1 + sizeY < this.currentHeight) {
                        this.unbreakable.add(this.getNodeId(x1 + i2, y1 + sizeY));
                    }
                    if (i2 == 0 && x1 > 0) {
                        this.unbreakable.add(this.getNodeId(x1 - 1, y1 + j));
                    }
                    if (i2 == sizeX - 1 && x1 + sizeX < this.currentWidth) {
                        this.unbreakable.add(this.getNodeId(x1 + sizeX, y1 + j));
                    }
                    if (i2 == 0 && x1 > 0 && j == 0 && y1 > 0) {
                        this.unbreakable.add(this.getNodeId(x1 - 1, y1 - 1));
                    }
                    if (i2 == sizeX - 1 && x1 + sizeX < this.currentWidth && j == sizeY - 1 && y1 + sizeY < this.currentHeight) {
                        this.unbreakable.add(this.getNodeId(x1 + sizeX, y1 + sizeY));
                    }
                    if (i2 == 0 && x1 > 0 && j == sizeY - 1 && y1 + sizeY < this.currentHeight) {
                        this.unbreakable.add(this.getNodeId(x1 - 1, y1 + sizeY));
                    }
                    if (i2 != sizeX - 1 || x1 + sizeX >= this.currentWidth || j != 0 || y1 <= 0) continue;
                    this.unbreakable.add(this.getNodeId(x1 + sizeX, y1 - 1));
                }
            }
        }
        return true;
    }

    public void end() {
        super.end();
    }
}

