/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import org.graphstream.algorithm.generator.BaseGenerator;

public class FlowerSnarkGenerator
extends BaseGenerator {
    private int nextStarNumber = 1;

    public void begin() {
        this.addStar();
        this.addStar();
        this.addStar();
        this.addEdge(N.B, 1, N.B, 2);
        this.addEdge(N.B, 2, N.B, 3);
        this.addEdge(N.B, 3, N.B, 1);
        this.addEdge(N.C, 1, N.C, 2);
        this.addEdge(N.C, 2, N.C, 3);
        this.addEdge(N.C, 3, N.D, 1);
        this.addEdge(N.D, 1, N.D, 2);
        this.addEdge(N.D, 2, N.D, 3);
        this.addEdge(N.D, 3, N.C, 1);
        this.flushCoords();
    }

    public boolean nextEvents() {
        this.delEdge(N.B, this.nextStarNumber - 1, N.B, 1);
        this.delEdge(N.C, this.nextStarNumber - 1, N.D, 1);
        this.delEdge(N.D, this.nextStarNumber - 1, N.C, 1);
        this.addStar();
        this.addEdge(N.B, this.nextStarNumber - 2, N.B, this.nextStarNumber - 1);
        this.addEdge(N.B, this.nextStarNumber - 1, N.B, 1);
        this.addEdge(N.C, this.nextStarNumber - 2, N.C, this.nextStarNumber - 1);
        this.addEdge(N.C, this.nextStarNumber - 1, N.D, 1);
        this.addEdge(N.D, this.nextStarNumber - 2, N.D, this.nextStarNumber - 1);
        this.addEdge(N.D, this.nextStarNumber - 1, N.C, 1);
        this.flushCoords();
        return true;
    }

    private void addStar() {
        int i = this.nextStarNumber++;
        this.addNode(N.A, i);
        this.addNode(N.B, i);
        this.addNode(N.C, i);
        this.addNode(N.D, i);
        this.addEdge(N.A, i, N.B, i);
        this.addEdge(N.A, i, N.C, i);
        this.addEdge(N.A, i, N.D, i);
    }

    private void addNode(N n, int i) {
        this.addNode(this.getNodeId(n, i));
    }

    protected String getNodeId(N n, int i) {
        return String.format("%s%04d", new Object[]{n, i});
    }

    private void addEdge(N n1, int i1, N n2, int i2) {
        this.addEdge(this.getEdgeId(n1, i1, n2, i2), this.getNodeId(n1, i1), this.getNodeId(n2, i2));
    }

    private void delEdge(N n1, int i1, N n2, int i2) {
        this.delEdge(this.getEdgeId(n1, i1, n2, i2));
    }

    protected String getEdgeId(N n1, int i1, N n2, int i2) {
        return String.format("%s%s", this.getNodeId(n1, i1), this.getNodeId(n2, i2));
    }

    protected void flushCoords() {
        double d = Math.PI * 2 / (double)(this.nextStarNumber - 1);
        for (int i = 1; i < this.nextStarNumber; ++i) {
            this.sendNodeAttributeChanged(this.sourceId, this.getNodeId(N.B, i), "x", null, Math.cos((double)(i - 1) * d));
            this.sendNodeAttributeChanged(this.sourceId, this.getNodeId(N.B, i), "y", null, Math.sin((double)(i - 1) * d));
            this.sendNodeAttributeChanged(this.sourceId, this.getNodeId(N.A, i), "x", null, 2.0 * Math.cos((double)(i - 1) * d));
            this.sendNodeAttributeChanged(this.sourceId, this.getNodeId(N.A, i), "y", null, 2.0 * Math.sin((double)(i - 1) * d));
            this.sendNodeAttributeChanged(this.sourceId, this.getNodeId(N.C, i), "x", null, 3.0 * Math.cos((double)(i - 1) * d - d / 4.0));
            this.sendNodeAttributeChanged(this.sourceId, this.getNodeId(N.C, i), "y", null, 3.0 * Math.sin((double)(i - 1) * d - d / 4.0));
            this.sendNodeAttributeChanged(this.sourceId, this.getNodeId(N.D, i), "x", null, 3.0 * Math.cos((double)(i - 1) * d + d / 4.0));
            this.sendNodeAttributeChanged(this.sourceId, this.getNodeId(N.D, i), "y", null, 3.0 * Math.sin((double)(i - 1) * d + d / 4.0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum N {
        A,
        B,
        C,
        D;

    }
}

