/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import org.graphstream.algorithm.generator.BaseGenerator;

public class BananaTreeGenerator
extends BaseGenerator {
    protected int k;
    protected int currentStarIndex;
    protected int edgeId;
    protected boolean setCoordinates;

    public BananaTreeGenerator() {
        this(4);
    }

    public BananaTreeGenerator(int k) {
        this.k = k;
        this.setCoordinates = true;
        this.currentStarIndex = 0;
        this.edgeId = 0;
    }

    public void begin() {
        this.addNode("root");
    }

    public boolean nextEvents() {
        this.addNode(this.getNodeId(this.currentStarIndex, 0));
        for (int i = 1; i < this.k; ++i) {
            this.addNode(this.getNodeId(this.currentStarIndex, i));
            this.addEdge(String.format("E%04d", this.edgeId++), this.getNodeId(this.currentStarIndex, 0), this.getNodeId(this.currentStarIndex, i));
        }
        this.addEdge(String.format("E%04d", this.edgeId++), this.getNodeId(this.currentStarIndex, 1), "root");
        ++this.currentStarIndex;
        if (this.setCoordinates) {
            this.flushCoords();
        }
        return true;
    }

    protected String getNodeId(int star, int index) {
        return String.format("S%02d_%02d", star, index);
    }

    protected void flushCoords() {
        this.sendNodeAttributeChanged(this.sourceId, "root", "x", null, 0);
        this.sendNodeAttributeChanged(this.sourceId, "root", "y", null, 0);
        double r1 = 8.0;
        for (int i = 0; i < this.currentStarIndex; ++i) {
            double a = (double)(i * 2) * Math.PI / (double)this.currentStarIndex;
            double rx = r1 * Math.cos(a);
            double ry = r1 * Math.sin(a);
            this.sendNodeAttributeChanged(this.sourceId, this.getNodeId(i, 0), "x", null, rx);
            this.sendNodeAttributeChanged(this.sourceId, this.getNodeId(i, 0), "y", null, ry);
            for (int j = 1; j < this.k; ++j) {
                double b = a - (double)((j - 1) * 2) * Math.PI / (double)(this.k - 1);
                double r2 = 0.8 * r1 * Math.sin(Math.PI / (double)this.currentStarIndex);
                this.sendNodeAttributeChanged(this.sourceId, this.getNodeId(i, j), "x", null, rx - r2 * Math.cos(b));
                this.sendNodeAttributeChanged(this.sourceId, this.getNodeId(i, j), "y", null, ry - r2 * Math.sin(b));
            }
        }
    }
}

