/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.community;

import java.util.HashMap;
import org.graphstream.algorithm.community.EpidemicCommunityAlgorithm;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

public class SyncEpidemicCommunityAlgorithm
extends EpidemicCommunityAlgorithm {
    protected int iteration = 0;

    public SyncEpidemicCommunityAlgorithm() {
    }

    public SyncEpidemicCommunityAlgorithm(Graph graph) {
        super(graph);
    }

    public SyncEpidemicCommunityAlgorithm(Graph graph, String marker) {
        super(graph, marker);
    }

    public void terminate() {
        this.iteration = 0;
    }

    public void compute() {
        super.compute();
        ++this.iteration;
    }

    public void computeNode(Node node) {
        if (node.hasAttribute(this.marker)) {
            node.setAttribute(this.marker + ".previous", new Object[]{node.getAttribute(this.marker)});
        }
        super.computeNode(node);
        node.setAttribute(this.marker + ".step", new Object[]{this.iteration});
    }

    protected void communityScores(Node u) {
        this.communityScores = new HashMap();
        for (Edge e : u.getEnteringEdgeSet()) {
            Node v = e.getOpposite(u);
            if (!v.hasAttribute(this.marker + ".step")) continue;
            String syncMarker = this.marker;
            int updateStep = (Integer)v.getAttribute(this.marker + ".step");
            if (updateStep == this.iteration) {
                syncMarker = syncMarker + ".previous";
            }
            if (!v.hasAttribute(syncMarker)) continue;
            if (this.communityScores.get(v.getAttribute(syncMarker)) == null) {
                this.communityScores.put(v.getAttribute(syncMarker), 1.0);
                continue;
            }
            this.communityScores.put(v.getAttribute(syncMarker), (Double)this.communityScores.get(v.getAttribute(syncMarker)) + 1.0);
        }
    }
}

