/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.HashSet;
import org.graphstream.algorithm.APSP;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

public class Centroid
implements Algorithm {
    protected Graph graph;
    protected String apspInfoAttribute;
    protected String centroidAttribute;
    protected Object isInCentroid;
    protected Object isNotInCentroid;

    public Centroid() {
        this("centroid");
    }

    public Centroid(String centroidAttribute) {
        this(centroidAttribute, Boolean.TRUE, Boolean.FALSE);
    }

    public Centroid(String centroidAttribute, Object isInCentroid, Object isNotInCentroid) {
        this(centroidAttribute, Boolean.TRUE, Boolean.FALSE, "APSPInfo");
    }

    public Centroid(String centroidAttribute, Object isInCentroid, Object isNotInCentroid, String apspInfoAttribute) {
        this.centroidAttribute = centroidAttribute;
        this.isInCentroid = isInCentroid;
        this.isNotInCentroid = isNotInCentroid;
        this.apspInfoAttribute = apspInfoAttribute;
    }

    public void init(Graph graph) {
        this.graph = graph;
    }

    public void compute() {
        float min = Float.MAX_VALUE;
        HashSet<Node> centroid = new HashSet<Node>();
        for (Node node : this.graph.getEachNode()) {
            float m = 0.0f;
            APSP.APSPInfo info = (APSP.APSPInfo)node.getAttribute(this.apspInfoAttribute);
            if (info == null) {
                System.err.printf("APSPInfo missing. Did you compute APSP before ?\n", new Object[0]);
            }
            for (Node other : this.graph.getEachNode()) {
                if (node == other) continue;
                double d = info.getLengthTo(other.getId());
                if (d < 0.0) {
                    System.err.printf("Found a negative length value in centroid algorithm. Is graph connected ?\n", new Object[0]);
                    continue;
                }
                m = (float)((double)m + d);
            }
            if (m < min) {
                centroid.clear();
                centroid.add(node);
                min = m;
                continue;
            }
            if (m != min) continue;
            centroid.add(node);
        }
        for (Node node : this.graph.getEachNode()) {
            node.setAttribute(this.centroidAttribute, new Object[]{centroid.contains(node) ? this.isInCentroid : this.isNotInCentroid});
        }
        centroid.clear();
    }

    public String getAPSPInfoAttribute() {
        return this.apspInfoAttribute;
    }

    public void setAPSPInfoAttribute(String attribute) {
        this.apspInfoAttribute = attribute;
    }

    public Object getIsInCentroidValue() {
        return this.isInCentroid;
    }

    public void setIsInCentroidValue(Object value) {
        this.isInCentroid = value;
    }

    public Object getIsNotInCentroidValue() {
        return this.isNotInCentroid;
    }

    public void setIsNotInCentroidValue(Object value) {
        this.isNotInCentroid = value;
    }

    public String getCentroidAttribute() {
        return this.centroidAttribute;
    }

    public void setCentroidAttribute(String centroidAttribute) {
        this.centroidAttribute = centroidAttribute;
    }
}

