/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.algorithm.Toolkit;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.Path;

public class AStar
implements Algorithm {
    protected Graph graph;
    protected String source;
    protected String target;
    protected Costs costs = new DefaultCosts();
    protected HashMap<Node, AStarNode> open = new HashMap();
    protected HashMap<Node, AStarNode> closed = new HashMap();
    protected Path result;
    protected boolean pathFound = false;

    public AStar() {
    }

    public AStar(Graph graph) {
        this.init(graph);
    }

    public AStar(Graph graph, String src, String trg) {
        this(graph);
        this.setSource(src);
        this.setTarget(trg);
    }

    public void setSource(String nodeName) {
        this.clearAll();
        this.source = nodeName;
    }

    public void setTarget(String nodeName) {
        this.clearAll();
        this.target = nodeName;
    }

    public void setCosts(Costs costs) {
        this.costs = costs;
    }

    public void init(Graph graph) {
        this.clearAll();
        this.graph = graph;
    }

    public void compute() {
        if (this.source != null && this.target != null) {
            Node sourceNode = this.graph.getNode(this.source);
            Node targetNode = this.graph.getNode(this.target);
            if (sourceNode == null) {
                throw new RuntimeException("source node '" + this.source + "' does not exist in the graph");
            }
            if (targetNode == null) {
                throw new RuntimeException("target node '" + this.target + "' does not exist in the graph");
            }
            this.aStar(sourceNode, targetNode);
        }
    }

    public Path getShortestPath() {
        return this.result;
    }

    public boolean noPathFound() {
        return !this.pathFound;
    }

    public Path buildPath(AStarNode target) {
        Path path = new Path();
        ArrayList<AStarNode> thePath = new ArrayList<AStarNode>();
        AStarNode node = target;
        while (node != null) {
            thePath.add(node);
            node = node.parent;
        }
        int n = thePath.size();
        if (n > 1) {
            AStarNode current = (AStarNode)thePath.get(n - 1);
            AStarNode follow = (AStarNode)thePath.get(n - 2);
            path.add(current.node, follow.edge);
            current = follow;
            for (int i = n - 3; i >= 0; --i) {
                follow = (AStarNode)thePath.get(i);
                path.add(follow.edge);
                current = follow;
            }
        }
        return path;
    }

    public void compute(String source, String target) {
        this.setSource(source);
        this.setTarget(target);
        this.compute();
    }

    protected void clearAll() {
        this.open.clear();
        this.closed.clear();
        this.result = null;
        this.pathFound = false;
    }

    protected void aStar(Node sourceNode, Node targetNode) {
        this.clearAll();
        this.open.put(sourceNode, new AStarNode(sourceNode, null, null, 0.0, this.costs.heuristic(sourceNode, targetNode)));
        this.pathFound = false;
        while (!this.open.isEmpty()) {
            AStarNode current = this.getNextBetterNode();
            assert (current != null);
            if (current.node == targetNode) {
                assert (current.edge != null);
                this.pathFound = true;
                this.result = this.buildPath(current);
                return;
            }
            this.open.remove(current.node);
            this.closed.put(current.node, current);
            Iterator nexts = current.node.getLeavingEdgeIterator();
            while (nexts.hasNext()) {
                AStarNode alreadyInClosed;
                Edge edge = (Edge)nexts.next();
                Node next = edge.getOpposite(current.node);
                double h = this.costs.heuristic(next, targetNode);
                double g = current.g + this.costs.cost(current.node, edge, next);
                double f = g + h;
                AStarNode alreadyInOpen = this.open.get(next);
                if (alreadyInOpen != null && alreadyInOpen.rank <= f || (alreadyInClosed = this.closed.get(next)) != null && alreadyInClosed.rank <= f) continue;
                this.closed.remove(next);
                this.open.put(next, new AStarNode(next, edge, current, g, h));
            }
        }
    }

    protected AStarNode getNextBetterNode() {
        double min = 3.4028234663852886E38;
        AStarNode theChosenOne = null;
        for (AStarNode node : this.open.values()) {
            if (!(node.rank < min)) continue;
            theChosenOne = node;
            min = node.rank;
        }
        return theChosenOne;
    }

    protected class AStarNode {
        public Node node;
        public AStarNode parent;
        public Edge edge;
        public double g;
        public double h;
        public double rank;

        public AStarNode(Node node, Edge edge, AStarNode parent, double g, double h) {
            this.node = node;
            this.edge = edge;
            this.parent = parent;
            this.g = g;
            this.h = h;
            this.rank = g + h;
        }
    }

    public static class DistanceCosts
    implements Costs {
        public double heuristic(Node node, Node target) {
            double[] xy1 = Toolkit.nodePosition((Node)node);
            double[] xy2 = Toolkit.nodePosition((Node)target);
            double x = xy2[0] - xy1[0];
            double y = xy2[1] - xy1[1];
            double z = xy1.length > 2 && xy2.length > 2 ? xy2[2] - xy1[2] : 0.0;
            return Math.sqrt(x * x + y * y + z * z);
        }

        public double cost(Node parent, Edge edge, Node next) {
            return Toolkit.edgeLength((Edge)edge);
        }
    }

    public static class DefaultCosts
    implements Costs {
        protected String weightAttribute = "weight";

        public DefaultCosts() {
        }

        public DefaultCosts(String weightAttributeName) {
            this.weightAttribute = weightAttributeName;
        }

        public double heuristic(Node node, Node target) {
            return 0.0;
        }

        public double cost(Node parent, Edge edge, Node next) {
            if (edge != null && edge.hasNumber(this.weightAttribute)) {
                return edge.getNumber(this.weightAttribute);
            }
            return 1.0;
        }
    }

    public static interface Costs {
        public double heuristic(Node var1, Node var2);

        public double cost(Node var1, Edge var2, Node var3);
    }
}

