/*
 * Decompiled with CFR 0.152.
 */
package fang2.util;

import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class Platform {
    public static final int UNKNOWN = 0;
    public static final int MAC = 1;
    public static final int UNIX = 2;
    public static final int WINDOWS = 3;
    private static int platform = -1;
    private static boolean areStandardFontFamiliesAvailable;
    private static boolean fontsChecked;
    private static boolean isSwingAvailable;
    private static boolean swingChecked;
    private static boolean areCollectionsAvailable;
    private static boolean collectionsChecked;
    private static boolean isSunAudioAvailable;
    private static boolean sunAudioChecked;
    private static boolean isJMFAvailable;
    private static boolean jmfChecked;

    public static int getPlatform() {
        if (platform != -1) {
            return platform;
        }
        String string = System.getProperty("os.name", "").toLowerCase();
        if (string.startsWith("mac")) {
            platform = 1;
            return 1;
        }
        if (string.startsWith("windows")) {
            platform = 3;
            return 3;
        }
        if (string.startsWith("microsoft")) {
            platform = 3;
            return 3;
        }
        if (string.startsWith("ms")) {
            platform = 3;
            return 3;
        }
        if (string.startsWith("unix")) {
            platform = 2;
            return 2;
        }
        if (string.startsWith("linux")) {
            platform = 2;
            return 2;
        }
        platform = 0;
        return 0;
    }

    public static boolean isMac() {
        return Platform.getPlatform() == 1;
    }

    public static boolean isWindows() {
        return Platform.getPlatform() == 3;
    }

    public static boolean isUnix() {
        return Platform.getPlatform() == 2;
    }

    public static void setFileTypeAndCreator(String string, String string2, String string3) {
        if (!Platform.isMac()) {
            return;
        }
        try {
            Platform.setFileTypeAndCreator(new File(string), string2, string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFileTypeAndCreator(File file, String string, String string2) {
        if (!Platform.isMac()) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("com.apple.mrj.MRJOSType");
            Class<?> clazz2 = Class.forName("com.apple.mrj.MRJFileUtils");
            Class[] classArray = new Class[]{Class.forName("java.lang.String")};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Class[] classArray2 = new Class[]{Class.forName("java.io.File"), clazz, clazz};
            Method method = clazz2.getMethod("setFileTypeAndCreator", classArray2);
            Object[] objectArray = new Object[]{(string + "    ").substring(0, 4)};
            Object obj = constructor.newInstance(objectArray);
            Object[] objectArray2 = new Object[]{(string2 + "    ").substring(0, 4)};
            Object obj2 = constructor.newInstance(objectArray2);
            Object[] objectArray3 = new Object[]{file, obj, obj2};
            method.invoke(null, objectArray3);
        }
        catch (Exception exception) {}
    }

    public static int compareVersion(String string) {
        return Platform.compareVersion(System.getProperty("java.version"), string);
    }

    public static int compareVersion(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
            int n;
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            if (n2 == (n = Integer.parseInt(stringTokenizer2.nextToken()))) continue;
            return n2 < n ? -1 : 1;
        }
        if (stringTokenizer.hasMoreTokens()) {
            return 1;
        }
        if (stringTokenizer2.hasMoreTokens()) {
            return -1;
        }
        return 0;
    }

    public static boolean isSwingAvailable() {
        if (!swingChecked) {
            swingChecked = true;
            isSwingAvailable = false;
            if (Platform.compareVersion("1.2") >= 0) {
                try {
                    isSwingAvailable = Class.forName("javax.swing.JComponent") != null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return isSwingAvailable;
    }

    public static boolean isSunAudioAvailable() {
        if (!sunAudioChecked) {
            sunAudioChecked = true;
            try {
                isSunAudioAvailable = Class.forName("sun.audio.AudioPlayer") != null;
            }
            catch (Exception exception) {
                isSunAudioAvailable = false;
            }
        }
        return isSunAudioAvailable;
    }

    public static boolean isJMFAvailable() {
        if (!jmfChecked) {
            jmfChecked = true;
            try {
                isJMFAvailable = Class.forName("javax.media.Player") != null;
            }
            catch (Exception exception) {
                isJMFAvailable = false;
            }
        }
        return isJMFAvailable;
    }

    public static boolean areCollectionsAvailable() {
        if (!collectionsChecked) {
            collectionsChecked = true;
            try {
                areCollectionsAvailable = Class.forName("java.util.ArrayList") != null;
            }
            catch (Exception exception) {
                areCollectionsAvailable = false;
            }
        }
        return areCollectionsAvailable;
    }

    public static boolean areStandardFontFamiliesAvailable() {
        if (!fontsChecked) {
            fontsChecked = true;
            try {
                Class<?> clazz = Class.forName("java.awt.Toolkit");
                Method method = clazz.getMethod("getFontList", new Class[0]);
                String[] stringArray = (String[])method.invoke((Object)Toolkit.getDefaultToolkit(), new Object[0]);
                int n = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals("Serif") && !stringArray[i].equals("SansSerif") && !stringArray[i].equals("Monospaced")) continue;
                    ++n;
                }
                areStandardFontFamiliesAvailable = n == 3;
            }
            catch (Exception exception) {
                areStandardFontFamiliesAvailable = false;
            }
        }
        return areStandardFontFamiliesAvailable;
    }
}

