/*
 * Decompiled with CFR 0.152.
 */
package fang2.ui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class WindowPositioning {
    public static void centerWindowOverWindow(Window window, Window window2, int n) {
        int n2;
        Point point;
        Dimension dimension;
        Dimension dimension2 = window.getToolkit().getScreenSize();
        Dimension dimension3 = window.getSize();
        if (window2 == null) {
            dimension = dimension2;
            point = new Point(0, 0);
            n2 = (dimension2.height - dimension3.height) / 2;
        } else {
            dimension = window2.getSize();
            point = window2.getLocation();
            n2 = point.y + n;
        }
        Point point2 = new Point(point.x + (dimension.width - dimension3.width) / 2, n2);
        if (point2.x <= 0) {
            point2.x = 5;
        } else if (point2.x + dimension3.width >= dimension2.width) {
            point2.x = dimension2.width - dimension3.width - 5;
        }
        if (point2.y + dimension3.height >= dimension2.height - 50) {
            point2.y = dimension2.height - dimension3.height - 50 - 5;
        }
        window.setLocation(point2);
    }

    public static void staggerWindowOverWindow(Window window, Window window2, int n) {
        Dimension dimension = window.getToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        Point point = new Point(0, 0);
        if (window2 == null) {
            point.x = 10;
            point.y = 30;
        } else {
            point = window2.getLocation();
            point.x += n;
            point.y += n;
            if (point.x + dimension2.width >= dimension.width || point.y + dimension2.height >= dimension.height - 50) {
                point.x = 10;
                point.y = 30;
            }
        }
        window.setLocation(point);
    }

    public static void zoom(Window window, Dimension dimension) {
        Dimension dimension2 = window.getToolkit().getScreenSize();
        window.setLocation(new Point(10, 30));
        dimension2.width -= 20;
        dimension2.height -= 80;
        dimension2.width = Math.min(dimension2.width, dimension.width);
        dimension2.height = Math.min(dimension2.height, dimension.height);
        window.setSize(dimension2);
    }

    public static void trim(JFrame jFrame) {
        Dimension dimension = jFrame.getToolkit().getScreenSize();
        dimension.width -= 20;
        dimension.height -= 120;
        JComponent jComponent = (JComponent)jFrame.getContentPane();
        Dimension dimension2 = jComponent.getPreferredSize();
        dimension2.width = Math.min(dimension2.width, dimension.width);
        dimension2.height = Math.min(dimension2.height, dimension.height);
        jComponent.setPreferredSize(dimension2);
    }

    public static boolean tooBig(JFrame jFrame) {
        Dimension dimension = jFrame.getSize();
        return dimension.width > 780 || dimension.height > 560;
    }

    private WindowPositioning() {
        throw new UnsupportedOperationException();
    }
}

