/*
 * Decompiled with CFR 0.152.
 */
package fang2.ui;

import fang2.ui.FunButton;
import fang2.ui.FunPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Scanner;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HTMLDisplay
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final URL STYLE_SHEET = HTMLDisplay.class.getResource("resources/stylesheet.css");
    private JTextPane message;
    private URL filename;
    private static final Dimension DEFAULT_SIZE = new Dimension(300, 300);
    private FunButton closeButton;

    public HTMLDisplay(String string, URL uRL) {
        this.setTitle(string);
        this.filename = uRL;
        this.makeComponents();
        this.makeLayout();
        this.setSize(DEFAULT_SIZE);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public void setStyleSheet(URL uRL) {
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.message.getEditorKit();
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.importStyleSheet(uRL);
        hTMLEditorKit.setStyleSheet(styleSheet);
        this.message.setEditorKit(hTMLEditorKit);
        try {
            Scanner scanner = new Scanner(this.filename.openStream());
            String string = scanner.findWithinHorizon("[\\s\\S]*", 0);
            this.message.setPage(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.message.setEditable(false);
    }

    private void makeComponents() {
        this.message = new JTextPane();
        this.closeButton = new FunButton("Close Help Window", DEFAULT_SIZE);
        this.closeButton.addActionListener(this);
        try {
            HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
            StyleSheet styleSheet = new StyleSheet();
            styleSheet.importStyleSheet(STYLE_SHEET);
            hTMLEditorKit.setStyleSheet(styleSheet);
            this.message.setEditorKit(hTMLEditorKit);
            this.message.setEditable(false);
        }
        catch (Exception exception) {
            System.err.println("Is " + this.filename + " in the html directory above tipgame?");
            exception.printStackTrace();
        }
    }

    private void makeLayout() {
        FunPanel funPanel = new FunPanel();
        funPanel.setLayout(new BorderLayout());
        funPanel.add((Component)new JScrollPane(this.message), "Center");
        funPanel.add((Component)this.closeButton, "South");
        this.setContentPane(funPanel);
    }

    public void setContent(String string, URL uRL) {
        this.setTitle(string);
        try {
            String string2 = "";
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while (bufferedReader.ready()) {
                string2 = string2 + bufferedReader.readLine() + "<br>";
            }
            this.message.setText(string2);
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            try {
                this.message.setText("Tried to load " + string + ", but a problem occurred:\n" + "<pre>" + stringWriter.toString() + "</pre>");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setText(String string) {
        this.message.setText(string);
    }
}

