/*
 * Decompiled with CFR 0.152.
 */
package fang2.ui;

import fang2.ui.FunPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JButton;

public class FunButton
extends JButton
implements ComponentListener {
    private int oldWidth = -1;

    public FunButton(Dimension dimension) {
        this("", dimension);
    }

    public FunButton(String string, Dimension dimension) {
        super(string);
        this.setBackground(Color.RED);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.setOpaque(true);
        FunPainter.setProperties(dimension, this);
        this.addComponentListener(this);
    }

    public void paintComponent(Graphics graphics) {
        if (this.oldWidth < 0) {
            this.oldWidth = this.getSize().width;
        }
        super.paintComponent(graphics);
        this.setOpaque(false);
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.oldWidth < 0) {
            return;
        }
        Font font = this.getFont();
        double d = (double)this.getSize().width / (double)this.oldWidth;
        this.oldWidth = this.getSize().width;
        font = font.deriveFont((float)(d * (double)font.getSize2D()));
        this.setFont(font);
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }
}

