/*
 * Decompiled with CFR 0.152.
 */
package fang2.ui;

import fang2.core.Game;
import fang2.ui.FunButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class ErrorConsole
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final URL STYLE_SHEET = ErrorConsole.class.getResource("resources/stylesheet.css");
    private JTextPane message;
    private static final Dimension DEFAULT_SIZE = new Dimension(600, 600);
    private JButton closeButton;
    private static final ErrorConsole single = new ErrorConsole();
    private final LinkedList<String> errors = new LinkedList();

    private ErrorConsole() {
        this.setTitle("Runtime Errors");
        this.makeComponents();
        this.makeLayout();
        this.setSize(DEFAULT_SIZE);
    }

    public static void clear() {
        if (single != null && ErrorConsole.single.errors != null) {
            ErrorConsole.single.errors.clear();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.errors.size() == 0) {
            this.setVisible(false);
        } else if (this.errors.size() == 1) {
            this.errors.removeFirst();
            this.setVisible(false);
        } else if (this.errors.size() > 1) {
            this.errors.removeFirst();
            this.message.setText(this.errors.getFirst());
            this.message.setCaretPosition(0);
            if (this.errors.size() == 1) {
                this.closeButton.setText("Close Error Console");
            }
        }
    }

    private void makeComponents() {
        this.message = new JTextPane();
        this.closeButton = new FunButton("Close Error Console", DEFAULT_SIZE);
        this.closeButton.addActionListener(this);
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.importStyleSheet(STYLE_SHEET);
        hTMLEditorKit.setStyleSheet(styleSheet);
        this.message.setEditorKit(hTMLEditorKit);
        this.message.setEditable(false);
    }

    private void makeLayout() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)new JScrollPane(this.message), "Center");
        container.add((Component)this.closeButton, "South");
    }

    private static URL getSourceURL(String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"", "../", "../src/", "src/"}) {
            int n;
            String string3;
            int n2;
            String string4;
            URL uRL;
            try {
                if (Game.getCurrentGame().getCodeBase() != null && (uRL = new URL(Game.getCurrentGame().getCodeBase().toString() + "/" + string2 + string)) != null && uRL.openStream() != null) {
                    return uRL;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string4 = ErrorConsole.class.getCanonicalName();
                n2 = string4.split(Pattern.quote(".")).length - 1;
                string3 = "";
                for (n = 0; n < n2; ++n) {
                    string3 = string3 + "../";
                }
                uRL = ErrorConsole.class.getResource(string3 + string2 + string);
                if (uRL != null && uRL.openStream() != null) {
                    return uRL;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string4 = Game.getCurrentGame().getClass().getCanonicalName();
                n2 = string4.split(Pattern.quote(".")).length - 1;
                string3 = "";
                for (n = 0; n < n2; ++n) {
                    string3 = string3 + "../";
                }
                uRL = Game.getCurrentGame().getClass().getResource(string3 + string2 + string);
                if (uRL != null && uRL.openStream() != null) {
                    return uRL;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                uRL = new URL(string2 + string);
                if (uRL != null && uRL.openStream() != null) {
                    return uRL;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                uRL = new File(string2 + string).toURL();
                if (uRL == null || uRL.openStream() == null) continue;
                return uRL;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getLine(String string, int n) {
        try {
            URL uRL = ErrorConsole.getSourceURL(string);
            InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            for (int i = 1; i != n; ++i) {
                string2 = bufferedReader.readLine();
            }
            while (string2.indexOf(";") < 0) {
                string2 = string2 + "\n" + bufferedReader.readLine();
            }
            return string2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static String fixHTML(String string) {
        return string.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "\\\"").replace("\n", "<br>").replace(" ", "&nbsp;").replace("\t", "&nbsp;&nbsp;&nbsp;");
    }

    public static String fixedWidth(String string) {
        return "<span style=\"font-family: monospace; font-weight: bold;color: rgb(255, 255, 0);\">" + string + "</span>";
    }

    public static String indent(String string) {
        return "<div style=\"margin-left: 40px;\">" + string + "</div>";
    }

    public static String heading(String string) {
        return "<h1 style=\"color: rgb(255, 255, 255);\">" + string + "</h1><br>";
    }

    public static String subHeading(String string) {
        return "<h2 style=\"color: rgb(255, 255, 255);\">" + string + "</h2>";
    }

    public static String getLocationSection(Throwable throwable) {
        String string = ErrorConsole.subHeading("Error Location") + "This error was generated by line " + ErrorConsole.getErrorLineNumber(throwable) + " of the file<br>" + ErrorConsole.indent(ErrorConsole.fixedWidth(ErrorConsole.getErrorFile(throwable))) + "<br>" + "This line is <br>" + ErrorConsole.fixedWidth(ErrorConsole.fixHTML(ErrorConsole.getErrorLine(throwable))) + "<br>";
        if (throwable != null) {
            string = string + "<br>Exception Stack Trace:<br><br>";
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            string = string + ErrorConsole.fixedWidth("<pre>" + stringWriter.toString() + "</pre>");
        }
        return string;
    }

    public static String getErrorLine(Throwable throwable) {
        return ErrorConsole.getLine(ErrorConsole.getErrorFile(throwable), ErrorConsole.getErrorLineNumber(throwable));
    }

    public static int getErrorLineNumber(Throwable throwable) {
        return ErrorConsole.getErrorElement(throwable).getLineNumber();
    }

    public static String getErrorMethod(Throwable throwable) {
        return ErrorConsole.getErrorElement(throwable).getMethodName();
    }

    public static String getErrorFile(Throwable throwable) {
        StackTraceElement stackTraceElement = ErrorConsole.getErrorElement(throwable);
        String string = stackTraceElement.getClassName();
        string = string.replace('.', '/');
        string = string + ".java";
        return string;
    }

    public static StackTraceElement getErrorElement(Throwable throwable) {
        String string;
        int n;
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (n = 0; n < stackTraceElementArray.length && ((string = stackTraceElementArray[n].getClassName()).startsWith("fang2") || string.startsWith("java")); ++n) {
        }
        if (n == stackTraceElementArray.length) {
            return stackTraceElementArray[n - 1];
        }
        return stackTraceElementArray[n];
    }

    public static void addError(String string, String string2, Throwable throwable) {
        String string3 = ErrorConsole.heading(throwable.getClass().getCanonicalName()) + ErrorConsole.subHeading("Diagnosis") + string + "<br>" + ErrorConsole.subHeading("Suggested Fix") + string2 + ErrorConsole.getLocationSection(throwable);
        ErrorConsole.single.errors.add(string3);
        if (ErrorConsole.single.errors.size() == 1) {
            ErrorConsole.single.message.setText(string3);
            ErrorConsole.single.message.setCaretPosition(0);
            single.setVisible(true);
        } else {
            ErrorConsole.single.closeButton.setText("Next Error Message");
        }
    }

    public static void addUnknownError(Throwable throwable) {
        ErrorConsole.addError("Strange, this error does not come up often.", "Please make a jar of this game.  Email bug@fangengine.org the jar file along with a description of how to recreate the error.", throwable);
    }

    public static void registerExceptionHandler() {
        Thread.currentThread().setUncaughtExceptionHandler(new TopExceptionHandler());
    }

    public static boolean hasErrors() {
        return single != null && !ErrorConsole.single.errors.isEmpty();
    }

    private static class TopExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private TopExceptionHandler() {
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            ErrorConsole.addUnknownError(throwable);
        }
    }
}

