/*
 * Decompiled with CFR 0.152.
 */
package fang2.transformers;

import fang2.core.TransformerAdapter;

public class SpinTransformer
extends TransformerAdapter {
    private double angularVelocityRadians;
    private double maximumAVRadians;
    private double minimumAVRadians;
    private double nominalAVRadians;
    private boolean resetToNominal;

    public SpinTransformer(double d) {
        this.angularVelocityRadians = Math.toRadians(d);
        this.minimumAVRadians = -1.7976931348623157E308;
        this.maximumAVRadians = Double.MAX_VALUE;
        this.nominalAVRadians = 0.0;
        this.boundAngularVelocity();
    }

    public void advance(double d) {
        this.setRotation(d * this.angularVelocityRadians);
    }

    public void nonMaskableAdvance(double d) {
        if (this.resetToNominal()) {
            this.setRotation(this.nominalAVRadians);
        }
    }

    public double getAngularVelocity() {
        return this.angularVelocityRadians;
    }

    public double getAngularVelocityDegrees() {
        return Math.toDegrees(this.getAngularVelocity());
    }

    public double getAngularVelocityRadians() {
        return this.getAngularVelocity();
    }

    public double getAngularVelocityRevolutions() {
        return this.getAngularVelocity() / (Math.PI * 2);
    }

    public double getMaximumAngularVelocity() {
        return this.maximumAVRadians;
    }

    public double getMaximumAngularVelocityDegrees() {
        return Math.toDegrees(this.getMaximumAngularVelocity());
    }

    public double getMaximumAngularVelocityRadians() {
        return this.getMaximumAngularVelocity();
    }

    public double getMaximumAngularVelocityRevolutions() {
        return this.getMaximumAngularVelocity() / (Math.PI * 2);
    }

    public double getMinimumAngularVelocity() {
        return this.minimumAVRadians;
    }

    public double getMinimumAngularVelocityDegrees() {
        return Math.toDegrees(this.getMinimumAngularVelocity());
    }

    public double getMinimumAngularVelocityRadians() {
        return this.getMinimumAngularVelocity();
    }

    public double getMinimumAngularVelocityRevolutions() {
        return this.getMinimumAngularVelocity() / (Math.PI * 2);
    }

    public double getNominalAngularVelocity() {
        return this.nominalAVRadians;
    }

    public double getNominalAngularVelocityDegrees() {
        return Math.toDegrees(this.getNominalAngularVelocity());
    }

    public double getNominalAngularVelocityRadians() {
        return this.getNominalAngularVelocity();
    }

    public double getNominalAngularVelocityRevolutions() {
        return this.getNominalAngularVelocity() / (Math.PI * 2);
    }

    public boolean resetToNominal() {
        return this.resetToNominal;
    }

    public void setAngularVelocity(double d) {
        this.angularVelocityRadians = d;
        this.boundAngularVelocity();
    }

    public void setAngularVelocityDegrees(double d) {
        this.setAngularVelocity(Math.toRadians(d));
    }

    public void setAngularVelocityRadians(double d) {
        this.setAngularVelocity(d);
    }

    public void setAngularVelocityRevolutions(double d) {
        this.setAngularVelocity(d * 2.0 * Math.PI);
    }

    public void setMaximumAngularVelocity(double d) {
        this.maximumAVRadians = d;
        this.boundAngularVelocity();
    }

    public void setMaximumAngularVelocityDegrees(double d) {
        this.setMaximumAngularVelocity(Math.toRadians(d));
    }

    public void setMaximumAngularVelocityRadians(double d) {
        this.setMaximumAngularVelocity(d);
    }

    public void setMaximumAngularVelocityRevolutions(double d) {
        this.setMaximumAngularVelocity(d * 2.0 * Math.PI);
    }

    public void setMinimumAngularVelocity(double d) {
        this.minimumAVRadians = d;
        this.boundAngularVelocity();
    }

    public void setMinimumAngularVelocityDegrees(double d) {
        this.setMinimumAngularVelocity(Math.toRadians(d));
    }

    public void setMinimumAngularVelocityRadians(double d) {
        this.setMinimumAngularVelocity(d);
    }

    public void setMinimumAngularVelocityRevolutions(double d) {
        this.setMinimumAngularVelocity(d * 2.0 * Math.PI);
    }

    public void setNominalAngularVelocity(double d) {
        this.nominalAVRadians = d;
    }

    public void setNominalAngularVelocityDegrees(double d) {
        this.setNominalAngularVelocity(Math.toRadians(d));
    }

    public void setNominalAngularVelocityRadians(double d) {
        this.setNominalAngularVelocity(d);
    }

    public void setNominalAngularVelocityRevolutions(double d) {
        this.setNominalAngularVelocity(d * 2.0 * Math.PI);
    }

    public void setResetToNominal(boolean bl) {
        this.resetToNominal = bl;
    }

    private void boundAngularVelocity() {
        if (this.angularVelocityRadians < this.minimumAVRadians) {
            this.angularVelocityRadians = this.minimumAVRadians;
        }
        if (this.angularVelocityRadians > this.maximumAVRadians) {
            this.angularVelocityRadians = this.maximumAVRadians;
        }
    }
}

