/*
 * Decompiled with CFR 0.152.
 */
package fang2.transformers;

import fang2.attributes.Location2D;
import fang2.core.Game;
import fang2.core.TransformerAdapter;
import fang2.transformers.MouseClickTransformerListener;
import java.util.ArrayList;

public class MouseClickTransformer
extends TransformerAdapter {
    private final int playerId;
    private final ArrayList<MouseClickTransformerListener> listeners;

    public MouseClickTransformer(int n) {
        this.playerId = n;
        this.listeners = new ArrayList();
    }

    public MouseClickTransformer() {
        this(0);
    }

    public void add(MouseClickTransformerListener mouseClickTransformerListener) {
        this.listeners.add(mouseClickTransformerListener);
        mouseClickTransformerListener.addTransformer(this);
    }

    public void remove(MouseClickTransformerListener mouseClickTransformerListener) {
        this.listeners.remove(mouseClickTransformerListener);
        mouseClickTransformerListener.removeTransformer(this);
    }

    public void advance(double d) {
        Location2D location2D = Game.getCurrentGame().getLeftClick2D(this.playerId);
        if (location2D != null) {
            for (MouseClickTransformerListener mouseClickTransformerListener : this.listeners) {
                mouseClickTransformerListener.mouseClickedAt(location2D, 1);
            }
        }
        if ((location2D = Game.getCurrentGame().getMiddleClick2D(this.playerId)) != null) {
            for (MouseClickTransformerListener mouseClickTransformerListener : this.listeners) {
                mouseClickTransformerListener.mouseClickedAt(location2D, 2);
            }
        }
        if ((location2D = Game.getCurrentGame().getRightClick2D(this.playerId)) != null) {
            for (MouseClickTransformerListener mouseClickTransformerListener : this.listeners) {
                mouseClickTransformerListener.mouseClickedAt(location2D, 3);
            }
        }
    }
}

