/*
 * Decompiled with CFR 0.152.
 */
package fang2.transformers;

import fang2.core.Game;
import fang2.core.Sprite;
import fang2.core.TransformerAdapter;

public class KeyboardTransformer
extends TransformerAdapter {
    private final StringBuffer minusKeys;
    private int playerNumber;
    private final StringBuffer plusKeys;
    private final TransformerAdapter transformer;

    public KeyboardTransformer(TransformerAdapter transformerAdapter) {
        this(transformerAdapter, 0);
    }

    public KeyboardTransformer(TransformerAdapter transformerAdapter, int n) {
        this.transformer = transformerAdapter;
        this.plusKeys = new StringBuffer();
        this.minusKeys = new StringBuffer();
    }

    public void addMinusKey(int n) {
        this.minusKeys.append((char)n);
    }

    public void addPlusKey(int n) {
        this.plusKeys.append((char)n);
    }

    public void advance(double d) {
        Game game = Game.getCurrentGame();
        if (game.keyPressed(this.playerNumber)) {
            String string = Character.toString(game.getKeyPressed(this.playerNumber));
            if (this.plusKeys.indexOf(string) >= 0) {
                this.transformer.advance(d);
            } else if (this.minusKeys.indexOf(string) >= 0) {
                this.transformer.advance(-d);
            }
        }
    }

    public String getMinusKeys() {
        return this.minusKeys.toString();
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public String getPlusKeys() {
        return this.plusKeys.toString();
    }

    public void nonMaskableAdvance(double d) {
        this.transformer.nonMaskableAdvance(d);
    }

    public void removeMinusKey(int n) {
        int n2 = this.minusKeys.indexOf(Character.toString((char)n));
        if (n2 >= 0) {
            this.minusKeys.deleteCharAt(n2);
        }
    }

    public void removePlusKey(int n) {
        int n2 = this.plusKeys.indexOf(Character.toString((char)n));
        if (n2 >= 0) {
            this.plusKeys.deleteCharAt(n2);
        }
    }

    public void updateSprite(Sprite sprite) {
        this.transformer.updateSprite(sprite);
    }
}

