/*
 * Decompiled with CFR 0.152.
 */
package fang2.transformers;

import fang2.core.Sprite;
import fang2.core.Transformer;

public abstract class InterpolatorTransformer
implements Transformer {
    private double currTime;
    private boolean cycling;
    private double direction = 1.0;
    private boolean enabled;
    private boolean oscillating;
    private double transitionTime;

    public InterpolatorTransformer(double d, boolean bl) {
        this(d, bl, false, false);
    }

    public InterpolatorTransformer(double d, boolean bl, boolean bl2, boolean bl3) {
        this.transitionTime = d;
        this.currTime = 0.0;
        this.enabled = bl;
        this.cycling = bl2;
        this.oscillating = bl3;
    }

    public void advance(double d) {
        if (this.enabled) {
            this.currTime += this.direction * d;
            if (this.currTime < 0.0) {
                this.currTime = 0.0;
                this.direction = this.oscillating ? 1.0 : 0.0;
            } else if (this.currTime > this.transitionTime) {
                this.currTime = this.transitionTime;
                if (this.oscillating) {
                    this.direction = -1.0;
                } else if (this.cycling) {
                    this.currTime = 0.0;
                } else {
                    this.direction = 0.0;
                }
            }
            this.interpolate(this.interpolateValue());
        }
    }

    public double getTransitionTime() {
        return this.transitionTime;
    }

    public boolean isCycling() {
        return this.cycling;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isOscillating() {
        return this.oscillating;
    }

    public void nonMaskableAdvance(double d) {
    }

    public void setCycling(boolean bl) {
        this.cycling = bl;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setOscillating(boolean bl) {
        this.oscillating = bl;
    }

    public void setTransitionTime(double d) {
        this.transitionTime = d;
    }

    public abstract void updateSprite(Sprite var1);

    private double interpolateValue() {
        return this.currTime / this.transitionTime;
    }

    protected abstract void interpolate(double var1);
}

