/*
 * Decompiled with CFR 0.152.
 */
package fang2.transformers;

import fang2.core.Game;
import fang2.core.Sprite;
import fang2.transformers.HitSpriteTransformer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HitClassTransformer
extends HitSpriteTransformer {
    private final List<Class<? extends Sprite>> targetClasses = new ArrayList<Class<? extends Sprite>>();

    public HitClassTransformer(Sprite sprite) {
        super(sprite);
    }

    public HitClassTransformer(Sprite sprite, Class<? extends Sprite> clazz) {
        this(sprite);
        this.targetClasses.add(clazz);
    }

    public void add(Class<? extends Sprite> clazz) {
        if (this.targetClasses.indexOf(clazz) < 0) {
            this.targetClasses.add(clazz);
        }
    }

    public void remove(Class<? extends Sprite> clazz) {
        this.targetClasses.remove(clazz);
    }

    private void collectUpSprites() {
        List<Sprite> list = this.getTargets();
        list.clear();
        Game game = Game.getCurrentGame();
        block0: for (Sprite sprite : game.getCanvas().getAllSprites()) {
            for (Class<? extends Sprite> clazz : this.targetClasses) {
                if (!clazz.isInstance(sprite)) continue;
                list.add(sprite);
                continue block0;
            }
        }
    }

    @Override
    public void advance(double d) {
        this.collectUpSprites();
        super.advance(d);
    }
}

