/*
 * Decompiled with CFR 0.152.
 */
package fang2.sprites;

import fang2.attributes.Location2D;
import fang2.core.Sprite;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class PolygonSprite
extends Sprite {
    public PolygonSprite(double ... dArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)dArray[0], (float)dArray[1]);
        for (int i = 2; i < dArray.length; i += 2) {
            generalPath.lineTo((float)dArray[i], (float)dArray[i + 1]);
        }
        generalPath.closePath();
        this.setAbsoluteShape(generalPath);
    }

    public PolygonSprite(Point2D.Double ... doubleArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)doubleArray[0].x, (float)doubleArray[0].x);
        for (int i = 1; i < doubleArray.length; ++i) {
            generalPath.lineTo((float)doubleArray[i].x, (float)doubleArray[i].y);
        }
        generalPath.closePath();
        this.setAbsoluteShape(generalPath);
    }

    public PolygonSprite(Location2D ... location2DArray) {
        this((Point2D.Double[])location2DArray);
    }

    public PolygonSprite(int n) {
        if (n < 3) {
            n = 3;
        }
        double d = -1.5707963267948966;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)Math.cos(d) * 0.5f, (float)Math.sin(d) * 0.5f);
        for (int i = 1; i < n; ++i) {
            d = -1.5707963267948966 + (double)(i * 2) * Math.PI / (double)n;
            generalPath.lineTo((float)Math.cos(d) * 0.5f, (float)Math.sin(d) * 0.5f);
        }
        generalPath.closePath();
        this.setAbsoluteShape(generalPath);
    }
}

