/*
 * Decompiled with CFR 0.152.
 */
package fang2.sprites;

import fang2.core.Game;
import fang2.sprites.StringSprite;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class InputStringSprite
extends StringSprite {
    private final ArrayList<Integer> players = new ArrayList();

    public InputStringSprite() {
        this(0);
    }

    public InputStringSprite(int ... nArray) {
        for (int n : nArray) {
            this.players.add(n);
        }
        this.leftJustify();
        this.topJustify();
    }

    public void addPlayerInput(int ... nArray) {
        for (int n : nArray) {
            if (this.players.contains(n)) continue;
            this.players.add(n);
        }
    }

    public void removePlayerInput(int ... nArray) {
        for (int n : nArray) {
            if (!this.players.contains(n)) continue;
            this.players.remove(this.players.indexOf(n));
        }
    }

    public void clearPlayerInput() {
        this.players.clear();
    }

    public boolean canInput(int n) {
        return this.players.contains(n);
    }

    public void update() {
        for (int n : this.players) {
            if (!Game.getCurrentGame().keyPressed(n)) continue;
            char c = Game.getCurrentGame().getKeyPressed(n);
            if (c == '\b' || c == '\u007f') {
                String string = this.getText();
                if (string.length() <= 0) continue;
                this.setText(string.substring(0, string.length() - 1));
                continue;
            }
            if (c == '\n') {
                this.setText(this.getText() + "\n");
                continue;
            }
            if (!Pattern.matches("\\p{Print}", "" + c)) continue;
            this.setText(this.getText() + c);
        }
    }
}

