/*
 * Decompiled with CFR 0.152.
 */
package fang2.sprites;

import fang2.attributes.Location2D;
import fang2.core.GameLoop;
import fang2.core.Sprite;
import fang2.media.RawMediaCache;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.VolatileImage;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;

public class ImageSprite
extends Sprite {
    public static GraphicsConfiguration configuration;
    private int animationIndex = -1;
    private Image[] animatedBuffer;
    private Image[] baseBuffer;
    private int delay;
    private int[] delaySegments;
    private Shape[] animatedShapes;
    private Shape originalShape;
    private Image image;
    private Image buffered;
    private double bufferedScale;
    private Dimension bufferSize;
    private final Point2D.Double shear = new Point2D.Double();
    private final Point2D.Double flip = new Point2D.Double(1.0, 1.0);
    private TexturePaint fill = null;
    private boolean flipchange = false;
    private boolean seamless = false;
    private long animationStart;
    private boolean looping = true;
    private final boolean keepAspect;
    static HashMap<URL, Image> imageCache;
    static HashMap<Image, URL> reverseMap;
    static HashMap<Image, Image[]> animatedMap;
    static HashMap<Image, Image[]> baseMap;
    static HashMap<String, Image> resizedCache;
    static HashMap<URL, Shape[]> shapeCache;
    static HashMap<Image, int[]> delayMap;
    private static final URL ERROR;
    private double inverse;
    private Point2D.Double fillLocation = new Point2D.Double();
    private URL fileURL;
    private boolean useClip = false;

    public ImageSprite(String string) {
        this(string, true);
    }

    public void normalize() {
    }

    public ImageSprite(String string, boolean bl) {
        this.keepAspect = bl;
        URL uRL = GameLoop.getGameResource(string);
        if (uRL == null) {
            System.err.println(string + "\nis not a valid image file.");
        }
        this.initialize(uRL);
    }

    public ImageSprite(URL uRL, boolean bl) {
        this.keepAspect = bl;
        this.initialize(uRL);
    }

    public ImageSprite clone() {
        ImageSprite imageSprite = new ImageSprite(this.fileURL, this.keepAspect);
        imageSprite.setShape(this.getShape());
        imageSprite.setColor(this.getColor());
        imageSprite.setScale(this.getScale());
        imageSprite.setRotation(this.getRotation());
        imageSprite.setLocation(this.getLocation());
        imageSprite.setBlurLength(this.getBlurLength());
        imageSprite.setImageIndex(this.animationIndex);
        imageSprite.delay = this.delay;
        imageSprite.setShear(this.shear.x, this.shear.y);
        if (this.flip.x < 0.0) {
            imageSprite.flipAlongVerticalAxis();
        }
        if (this.flip.y < 0.0) {
            imageSprite.flipAlongHorizontalAxis();
        }
        imageSprite.fill = this.fill;
        imageSprite.seamless = this.seamless;
        imageSprite.animationStart = this.animationStart;
        imageSprite.looping = this.looping;
        imageSprite.inverse = this.inverse;
        imageSprite.fillLocation = new Point2D.Double(this.fillLocation.x, this.fillLocation.y);
        return imageSprite;
    }

    private void clean() {
        this.animationIndex = -1;
        this.animatedBuffer = null;
        this.animatedShapes = null;
        this.originalShape = null;
        this.baseBuffer = null;
        this.delay = 0;
        this.delaySegments = null;
        this.image = null;
        this.buffered = null;
        this.bufferedScale = 0.0;
        this.bufferSize = null;
        this.fill = null;
        this.animationStart = 0L;
        this.inverse = 0.0;
        this.fillLocation = new Point2D.Double();
        this.fileURL = null;
        this.useClip = false;
    }

    public void setImage(String string) {
        URL uRL = GameLoop.getGameResource(string);
        if (uRL == null) {
            System.err.println(string + "\nis not a valid image file.");
        }
        this.initialize(uRL);
    }

    private void initialize(URL uRL) {
        this.clean();
        if (!this.initializeImage(uRL)) {
            uRL = ERROR;
            System.out.println("ERROR is " + ERROR);
            this.initializeImage(uRL);
        }
        this.fileURL = uRL;
        this.buffered = this.image = imageCache.get(uRL);
        int n = this.image.getWidth(null);
        int n2 = this.image.getHeight(null);
        double d = Math.max(n, n2);
        this.inverse = 10.0;
        this.bufferSize = this.keepAspect ? new Dimension((int)d, (int)d) : new Dimension(n, n2);
        this.bufferedScale = 0.0;
        this.initializeAnimatedBuffer();
        this.loadAnimatedShapes();
        this.originalShape = this.baseBuffer != null ? this.getShape(this.baseBuffer, 0) : this.getShape(this.image);
        super.setShape(this.originalShape);
    }

    public void setShape(Shape shape) {
        this.useClip = true;
        Area area = new Area(shape);
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d = Math.max(rectangle2D.getWidth(), rectangle2D.getHeight());
        area.transform(AffineTransform.getScaleInstance(1.0 / d, 1.0 / d));
        rectangle2D = area.getBounds2D();
        area.transform(AffineTransform.getTranslateInstance(-rectangle2D.getWidth() / 2.0 - rectangle2D.getX(), -rectangle2D.getHeight() / 2.0 - rectangle2D.getY()));
        this.originalShape = new Area(area);
        for (int i = 0; this.animatedShapes != null && i < this.animatedShapes.length; ++i) {
            this.animatedShapes[i] = new Area(this.originalShape);
            ((Area)this.animatedShapes[i]).intersect(new Area(this.getShape(this.baseBuffer, i)));
        }
        ((Area)this.originalShape).intersect(new Area(this.getShape(this.image)));
        super.setShape(this.originalShape);
    }

    public void flipAlongVerticalAxis() {
        this.flip.x = this.flip.x > 0.0 ? -1.0 : 1.0;
        this.flipchange = true;
    }

    public void flipAlongHorizontalAxis() {
        this.flip.y = this.flip.y > 0.0 ? (this.flip.y *= -1.0) : 1.0;
        this.flipchange = true;
    }

    public void setShear(double d, double d2) {
        this.shear.x = d;
        this.shear.y = d2;
    }

    private boolean initializeImage(URL uRL) {
        if (imageCache.containsKey(uRL)) {
            this.image = imageCache.get(uRL);
        } else {
            try {
                RawMediaCache.loadAndWait(uRL);
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(RawMediaCache.getCachedStream(uRL));
                Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                ImageReader imageReader = iterator.next();
                imageReader.setInput(imageInputStream);
                this.image = imageReader.read(0);
                if (this.image == null) {
                    return false;
                }
            }
            catch (Exception exception) {
                System.err.println("Null URL given to ImageSprite.\nCheck for spelling and case sensitivity\nin the URL used at the line number indicated\nbelow at the first line that starts with\nthe name of a class that you wrote.");
                exception.printStackTrace();
                return false;
            }
            imageCache.put(uRL, this.image);
            reverseMap.put(this.image, uRL);
        }
        return true;
    }

    private void initializeAnimatedBuffer() {
        if (animatedMap.containsKey(this.buffered)) {
            this.animatedBuffer = animatedMap.get(this.buffered);
            if (baseMap.containsKey(this.image)) {
                this.baseBuffer = baseMap.get(this.image);
            } else {
                this.baseBuffer = this.animatedBuffer;
                baseMap.put(this.image, this.baseBuffer);
            }
            this.delaySegments = delayMap.get(this.image);
            this.delay = 0;
            for (int n : this.delaySegments) {
                this.delay += n;
            }
        } else {
            if (this.baseBuffer != null) {
                if (!delayMap.containsKey(this.image)) {
                    this.initialize(this.fileURL);
                }
                this.delaySegments = delayMap.get(this.image);
                this.delay = 0;
                for (int n : this.delaySegments) {
                    this.delay += n;
                }
                this.animatedBuffer = new Image[this.baseBuffer.length];
                for (int i = 0; i < this.baseBuffer.length; ++i) {
                    Point point = new Point(this.buffered.getWidth(null), this.buffered.getHeight(null));
                    this.animatedBuffer[i] = this.baseBuffer[i].getScaledInstance(point.x, point.y, 2);
                    if (!(this.flip.x < 0.0) && !(this.flip.y < 0.0)) continue;
                    BufferedImage bufferedImage = new BufferedImage(point.x, point.y, 2);
                    this.fixAnnoyingWhiteBackground(bufferedImage);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    graphics2D.translate((double)point.x / 2.0, (double)point.y / 2.0);
                    graphics2D.scale(this.flip.x, this.flip.y);
                    graphics2D.translate((double)(-point.x) / 2.0, (double)(-point.y) / 2.0);
                    graphics2D.drawImage(this.animatedBuffer[i], 0, 0, null);
                    this.animatedBuffer[i] = bufferedImage;
                }
                animatedMap.put(this.buffered, this.animatedBuffer);
                return;
            }
            if (baseMap.containsKey(this.image)) {
                this.baseBuffer = baseMap.get(this.image);
            } else {
                this.loadImagesFromURL();
            }
        }
    }

    private void loadAnimatedShapes() {
        if (this.baseBuffer == null) {
            return;
        }
        this.animatedShapes = new Shape[this.baseBuffer.length];
        for (int i = 0; i < this.animatedShapes.length; ++i) {
            this.animatedShapes[i] = this.getShape(this.baseBuffer, i);
        }
    }

    private void loadImagesFromURL() {
        if (delayMap.containsKey(this.image)) {
            this.animatedBuffer = animatedMap.get(this.buffered);
            this.baseBuffer = this.animatedBuffer;
            this.delaySegments = delayMap.get(this.image);
        } else {
            try {
                System.out.println("Loading from url.");
                URL uRL = reverseMap.get(this.image);
                String string = uRL.getFile();
                String string2 = string.substring(string.lastIndexOf(46) + 1);
                Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string2);
                ImageReader imageReader = iterator.next();
                RawMediaCache.loadAndWait(uRL);
                InputStream inputStream = RawMediaCache.getCachedStream(uRL);
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
                imageReader.setInput(imageInputStream);
                int n = imageReader.getNumImages(true);
                if (n <= 1) {
                    delayMap.put(this.image, new int[]{100});
                    animatedMap.put(this.buffered, new Image[]{this.buffered});
                    inputStream.close();
                    return;
                }
                this.animatedBuffer = new Image[n];
                this.baseBuffer = new Image[n];
                this.delaySegments = new int[n];
                this.delay = 0;
                for (int i = 0; i < n; ++i) {
                    this.baseBuffer[i] = imageReader.read(i);
                    this.animatedBuffer[i] = this.baseBuffer[i];
                    IIOMetadata iIOMetadata = imageReader.getImageMetadata(i);
                    this.delaySegments[i] = 100;
                    this.delay += this.delaySegments[i];
                }
                delayMap.put(this.image, this.delaySegments);
                animatedMap.put(this.buffered, this.animatedBuffer);
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private double getActualScale() {
        return this.getScale() * this.inverse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBufferedImage() {
        if (this.buffered == null || this.getActualScale() != this.bufferedScale || this.flipchange) {
            this.flipchange = false;
            String string = this.flip.toString() + (int)this.getActualScale() + this.fileURL.getFile();
            if (resizedCache.containsKey(string)) {
                this.buffered = resizedCache.get(string);
            } else {
                Object object;
                Point point = new Point(Math.max(1, (int)((double)this.image.getWidth(null) * this.getActualScale() / (double)this.bufferSize.width)), Math.max(1, (int)((double)this.image.getHeight(null) * this.getActualScale() / (double)this.bufferSize.height)));
                this.buffered = configuration != null ? configuration.createCompatibleVolatileImage(point.x, point.y, 3) : new BufferedImage(point.x, point.y, 2);
                this.fixAnnoyingWhiteBackground(this.buffered);
                double d = (double)this.buffered.getHeight(null) / (double)this.image.getHeight(null);
                ((Graphics2D)this.buffered.getGraphics()).drawImage(this.image, AffineTransform.getScaleInstance(d, d), null);
                if (this.flip.x < 0.0 || this.flip.y < 0.0) {
                    object = configuration != null ? configuration.createCompatibleVolatileImage(point.x, point.y, 3) : new BufferedImage(point.x, point.y, 2);
                    this.fixAnnoyingWhiteBackground((Image)object);
                    Graphics2D graphics2D = (Graphics2D)((Image)object).getGraphics();
                    graphics2D.translate((double)point.x / 2.0, (double)point.y / 2.0);
                    graphics2D.scale(this.flip.x, this.flip.y);
                    graphics2D.translate((double)(-point.x) / 2.0, (double)(-point.y) / 2.0);
                    while (this.animatedBuffer == null && !graphics2D.drawImage(this.buffered, 0, 0, null)) {
                        ImageSprite imageSprite = this;
                        synchronized (imageSprite) {
                            try {
                                this.wait(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                    }
                    this.buffered = object;
                }
                while (this.buffered.getHeight(null) < point.y || this.buffered.getWidth(null) < point.x) {
                    object = this;
                    synchronized (object) {
                        try {
                            this.wait(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }
                resizedCache.put(string, this.buffered);
            }
            this.bufferedScale = this.getActualScale();
            if (this.animatedBuffer != null) {
                this.initializeAnimatedBuffer();
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        if (this.inverse != affineTransform.getScaleX()) {
            if (this.fill != null) {
                double d = this.getFill();
                this.inverse = affineTransform.getScaleX();
                if (!this.seamless) {
                    this.setFill(d);
                } else {
                    this.setSeamlessFill(d);
                }
            } else {
                this.inverse = affineTransform.getScaleX();
                this.bufferedScale = -1.0;
            }
        }
        graphics2D.setTransform(new AffineTransform());
        if (this.useClip) {
            Area area = new Area(this.getShape());
            area.intersect(new Area(shape));
            area.transform(AffineTransform.getScaleInstance(this.inverse, this.inverse));
            graphics2D.setClip(area);
        }
        this.updateBufferedImage();
        Dimension dimension = new Dimension(this.buffered.getWidth(null), this.buffered.getHeight(null));
        Location2D location2D = this.getLocation();
        graphics2D.translate(location2D.x * this.inverse, location2D.y * this.inverse);
        graphics2D.rotate(this.getRotation());
        graphics2D.shear(this.shear.x, this.shear.y);
        graphics2D.translate(-location2D.x * this.inverse, -location2D.y * this.inverse);
        this.drawReliably(graphics2D, this.buffered, (int)Math.round(this.inverse * location2D.x - (double)dimension.width / 2.0), (int)Math.round(this.inverse * location2D.y - (double)dimension.height / 2.0));
        if (this.outline != null) {
            graphics2D.setTransform(affineTransform);
            graphics2D.transform(this.transform);
            graphics2D.setColor(this.outlineColor);
            System.out.println("outlineColor: " + this.outlineColor);
            graphics2D.fill(this.outline);
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
    }

    public void setImageIndex(int n) {
        this.animationIndex = n;
        if (this.animatedShapes != null && n < this.animatedShapes.length) {
            super.setShape(this.animatedShapes[n]);
        }
    }

    public boolean isLooping() {
        return this.looping && this.baseBuffer != null;
    }

    public void setLooping(boolean bl) {
        this.looping = bl;
    }

    public int getImageIndex() {
        int n;
        if (this.animationIndex >= 0) {
            return this.animationIndex;
        }
        long l = System.currentTimeMillis() - this.animationStart;
        if (!this.looping && l > (long)this.delay) {
            return this.delaySegments.length - 1;
        }
        l %= (long)this.delay;
        for (n = 0; n < this.delaySegments.length; ++n) {
            if ((long)this.delaySegments[n] > l) {
                super.setShape(this.animatedShapes[n]);
                return n;
            }
            l -= (long)this.delaySegments[n];
        }
        n = this.delaySegments.length - 1;
        if (this.animatedShapes != null && n < this.animatedShapes.length) {
            super.setShape(this.animatedShapes[n]);
        }
        return n;
    }

    public void startAnimationNow() {
        this.animationStart = System.currentTimeMillis();
    }

    private void fillToShape(boolean bl) {
        double d = this.getRotation();
        this.setRotation(0.0);
        Rectangle2D rectangle2D = this.getBounds2D().Rectangle2D();
        double d2 = this.image.getWidth(null);
        double d3 = this.image.getHeight(null);
        double d4 = rectangle2D.getWidth() / rectangle2D.getHeight();
        double d5 = d2 / d3;
        if (d4 > 1.0) {
            d4 = 1.0 / d4;
            if (d5 < 1.0) {
                d4 /= d5;
            }
        } else if (d5 > 1.0) {
            d4 *= d5;
        }
        if (bl) {
            this.setSeamlessFill(2.0 * d4);
        } else {
            this.setFill(d4);
        }
        this.setFillPosition(new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY()));
        this.setRotation(d);
    }

    public void fillToShapeSeamless() {
        this.fillToShape(true);
    }

    public void fillToShape() {
        this.fillToShape(false);
    }

    public void setFill(double d) {
        if (d == 0.0) {
            this.fill = null;
            return;
        }
        this.seamless = false;
        double d2 = this.getScale();
        this.scale(d);
        this.updateBufferedImage();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.buffered.getWidth(null), this.buffered.getHeight(null));
        BufferedImage bufferedImage = new BufferedImage((int)double_.getWidth(), (int)double_.getHeight(), 2);
        this.fixAnnoyingWhiteBackground(bufferedImage);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        this.fill = null;
        if (this.animatedBuffer != null) {
            this.drawReliably(graphics2D, this.animatedBuffer[this.getImageIndex()], 0.0, 0.0);
        } else {
            this.drawReliably(graphics2D, this.buffered, 0.0, 0.0);
        }
        this.setScale(d2);
        this.updateBufferedImage();
        this.fill = new TexturePaint(bufferedImage, double_);
        this.setFillPosition(new Point2D.Double());
    }

    private void fixAnnoyingWhiteBackground(Image image) {
        Graphics2D graphics2D = (Graphics2D)image.getGraphics();
        Color color = graphics2D.getColor();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setColor(new Color(0, 0, 0, 0));
        graphics2D.fillRect(0, 0, image.getWidth(null), image.getHeight(null));
        graphics2D.setComposite(composite);
        graphics2D.setColor(color);
    }

    public Point2D.Double getFillPosition() {
        if (this.fill == null) {
            return null;
        }
        return this.fillLocation;
    }

    public void setFillPosition(Point2D.Double double_) {
        if (this.fill == null) {
            return;
        }
        Rectangle2D rectangle2D = this.fill.getAnchorRect();
        rectangle2D = new Rectangle2D.Double(Math.round((this.getBounds2D().getMinX() + double_.x) * this.inverse), Math.round((this.getBounds2D().getMinY() + double_.y) * this.inverse), rectangle2D.getWidth(), rectangle2D.getHeight());
        this.fill = new TexturePaint(this.fill.getImage(), rectangle2D);
    }

    public void setSeamlessFill(double d) {
        if (d == 0.0) {
            this.fill = null;
            return;
        }
        this.seamless = true;
        double d2 = this.getScale();
        this.scale(d * 0.5);
        this.updateBufferedImage();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.buffered.getWidth(null) * 2, this.buffered.getHeight(null) * 2);
        BufferedImage bufferedImage = new BufferedImage((int)double_.getWidth(), (int)double_.getHeight(), 2);
        this.fixAnnoyingWhiteBackground(bufferedImage);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        this.fill = null;
        if (this.animatedBuffer != null) {
            this.drawReliably(graphics2D, this.animatedBuffer[this.getImageIndex()], 0.0, 0.0);
            this.flipAlongHorizontalAxis();
            this.updateBufferedImage();
            this.drawReliably(graphics2D, this.animatedBuffer[this.getImageIndex()], 0.0, double_.height / 2.0);
            this.flipAlongVerticalAxis();
            this.updateBufferedImage();
            this.drawReliably(graphics2D, this.animatedBuffer[this.getImageIndex()], double_.width / 2.0, double_.height / 2.0);
            this.flipAlongHorizontalAxis();
            this.updateBufferedImage();
            this.drawReliably(graphics2D, this.animatedBuffer[this.getImageIndex()], double_.width / 2.0, 0.0);
            this.flipAlongVerticalAxis();
        } else {
            this.drawReliably(graphics2D, this.buffered, 0.0, 0.0);
            this.flipAlongHorizontalAxis();
            this.updateBufferedImage();
            this.drawReliably(graphics2D, this.buffered, 0.0, double_.height / 2.0);
            this.flipAlongVerticalAxis();
            this.updateBufferedImage();
            this.drawReliably(graphics2D, this.buffered, double_.width / 2.0, double_.height / 2.0);
            this.flipAlongHorizontalAxis();
            this.updateBufferedImage();
            this.drawReliably(graphics2D, this.buffered, double_.width / 2.0, 0.0);
            this.flipAlongVerticalAxis();
        }
        this.setScale(d2);
        this.updateBufferedImage();
        this.fill = new TexturePaint(bufferedImage, double_);
        this.setFillPosition(new Point2D.Double());
    }

    public double getFill() {
        if (this.fill == null) {
            return -1.0;
        }
        double d = 1.0;
        return d * Math.min((double)this.fill.getImage().getWidth() / (double)this.buffered.getWidth(null), (double)this.fill.getImage().getHeight() / (double)this.buffered.getHeight(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawReliably(Graphics2D graphics2D, Image image, double d, double d2) {
        Paint paint = graphics2D.getPaint();
        if (this.animatedBuffer != null) {
            if (this.fill != null) {
                int n = Math.max(this.fill.getImage().getWidth(), this.fill.getImage().getHeight());
                if (this.seamless) {
                    this.setSeamlessFill(n / 2);
                } else {
                    this.setFill(n);
                }
                graphics2D.setPaint(this.fill);
                Area area = new Area(this.getShape());
                area.transform(AffineTransform.getScaleInstance(this.inverse, this.inverse));
                graphics2D.fill(area);
                graphics2D.setPaint(paint);
            } else {
                graphics2D.drawImage(this.animatedBuffer[this.getImageIndex()], (int)d, (int)d2, null);
            }
            return;
        }
        if (this.fill != null) {
            graphics2D.setPaint(this.fill);
            Area area = new Area(this.getShape());
            area.transform(AffineTransform.getScaleInstance(this.inverse, this.inverse));
            graphics2D.fill(area);
            return;
        }
        while (!graphics2D.drawImage(this.buffered, (int)Math.round(d), (int)Math.round(d2), null) && !(image instanceof VolatileImage)) {
            ImageSprite imageSprite = this;
            synchronized (imageSprite) {
                try {
                    this.wait(1L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public static void clearCache() {
        imageCache.clear();
        reverseMap.clear();
        animatedMap.clear();
        baseMap.clear();
        resizedCache.clear();
        delayMap.clear();
    }

    public Shape getShape(Image image) {
        return this.getShape(new Image[]{image}, 0);
    }

    public Shape getShape(Image[] imageArray, int n) {
        if (shapeCache.containsKey(this.fileURL)) {
            Area area = new Area(shapeCache.get(this.fileURL)[n]);
            return area;
        }
        Shape[] shapeArray = new Shape[imageArray.length];
        for (int i = 0; i < imageArray.length; ++i) {
            int n2;
            LinkedList linkedList;
            int n3;
            Object object;
            int n4 = imageArray[i].getHeight(null);
            int n5 = imageArray[i].getWidth(null);
            int[] nArray = new int[n5 * n4];
            try {
                object = new PixelGrabber(imageArray[i], 0, 0, n5, n4, nArray, 0, n5);
                ((PixelGrabber)object).grabPixels();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            object = new LinkedList();
            Point point = null;
            for (int j = 0; j < n4; ++j) {
                ((LinkedList)object).add(new LinkedList());
                n3 = 0;
                for (int k = 0; k < n5; ++k) {
                    int n6 = nArray[j * n5 + k] >> 24 & 0xFF;
                    if (n6 != 0 && n3 == 0 || n6 == 0 && n3 != 0) {
                        ((LinkedList)((LinkedList)object).get(j)).add(k);
                        if (point == null) {
                            point = new Point(k, j);
                        }
                    }
                    n3 = n6;
                }
                if (n3 == 0) continue;
                ((LinkedList)((LinkedList)object).get(j)).add(n5 - 1);
            }
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(point.x, point.y);
            n3 = point.y + 1;
            double d = point.x;
            while (n3 < ((LinkedList)object).size()) {
                linkedList = (LinkedList)((LinkedList)object).get(n3);
                if (!linkedList.isEmpty()) {
                    n2 = (Integer)linkedList.getFirst();
                    d = n2;
                    generalPath.lineTo(n2, n3);
                    ++n3;
                    continue;
                }
                generalPath.lineTo((float)d, n3);
                ++n3;
            }
            --n3;
            while (n3 > point.y) {
                linkedList = (LinkedList)((LinkedList)object).get(n3);
                if (!linkedList.isEmpty()) {
                    n2 = (Integer)linkedList.getLast();
                    d = n2;
                    generalPath.lineTo(n2, n3);
                    --n3;
                    continue;
                }
                generalPath.lineTo((float)d, n3);
                --n3;
            }
            generalPath.closePath();
            double d2 = 1.0 / (double)Math.max(n5, n4);
            generalPath.transform(AffineTransform.getTranslateInstance(-n5 / 2, -n4 / 2));
            generalPath.transform(AffineTransform.getScaleInstance(d2, d2));
            shapeArray[i] = generalPath;
        }
        shapeCache.put(this.fileURL, shapeArray);
        Area area = new Area(shapeCache.get(this.fileURL)[n]);
        return area;
    }

    static {
        imageCache = new HashMap();
        reverseMap = new HashMap();
        animatedMap = new HashMap();
        baseMap = new HashMap();
        resizedCache = new HashMap();
        shapeCache = new HashMap();
        delayMap = new HashMap();
        ERROR = ImageSprite.class.getResource("resources/badURL.gif");
    }
}

