/*
 * Decompiled with CFR 0.152.
 */
package fang2.sprites;

import fang2.attributes.Box2D;
import fang2.attributes.Location2D;
import fang2.core.Game;
import fang2.core.Sprite;
import fang2.core.Transformer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeSprite
extends Sprite {
    protected static Color debugCrosshairsColor = new Color(150, 150, 200);
    private final List<Sprite> sprites = new ArrayList<Sprite>();

    public void addSprite(Sprite sprite) {
        this.sprites.add(sprite);
    }

    public void addSprite(Sprite ... spriteArray) {
        for (Sprite sprite : spriteArray) {
            this.addSprite(sprite);
        }
    }

    public boolean contains(Sprite sprite) {
        return this.sprites.contains(sprite);
    }

    public List<Sprite> getAllSprites() {
        return this.sprites;
    }

    public Location2D getFrameLocation(Location2D location2D) {
        Location2D location2D2 = null;
        try {
            location2D2 = new Location2D(this.transform.inverseTransform(location2D, null));
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        return location2D2;
    }

    public Location2D getFrameLocation(double d, double d2) {
        return this.getFrameLocation(new Location2D(d, d2));
    }

    public Location2D getRealLocation(Location2D location2D) {
        Location2D location2D2 = null;
        try {
            location2D2 = new Location2D(this.transform.inverseTransform(location2D, null));
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        return location2D2;
    }

    public Location2D getRealLocation(double d, double d2) {
        return this.getRealLocation(new Location2D(d, d2));
    }

    @Override
    public void showOutline() {
        for (Sprite sprite : this.sprites) {
            sprite.showOutline();
        }
    }

    @Override
    public void setOutlineThickness(double d) {
        for (Sprite sprite : this.sprites) {
            sprite.setOutlineThickness(d);
        }
    }

    @Override
    public double getOutlineThickness() {
        if (this.sprites.size() > 0) {
            return this.sprites.get(0).getOutlineThickness();
        }
        return -1.0;
    }

    @Override
    public Color getOutlineColor() {
        if (this.sprites.size() > 0) {
            return this.sprites.get(0).getOutlineColor();
        }
        return super.getOutlineColor();
    }

    @Override
    public void setOutlineColor(Color color) {
        for (Sprite sprite : this.sprites) {
            sprite.setOutlineColor(color);
        }
    }

    @Override
    public void hideOutline() {
        for (Sprite sprite : this.sprites) {
            sprite.showOutline();
        }
    }

    @Override
    public void setDashLength(double d) {
        for (Sprite sprite : this.sprites) {
            sprite.setDashLength(d);
        }
    }

    @Override
    public double getDashLength() {
        if (this.sprites.size() > 0) {
            return this.sprites.get(0).getDashLength();
        }
        return 0.0;
    }

    @Override
    public void setDashPattern(float ... fArray) {
        for (Sprite sprite : this.sprites) {
            sprite.setDashPattern(fArray);
        }
    }

    @Override
    public float[] getDashPattern() {
        if (this.sprites.size() > 0) {
            return this.sprites.get(0).getDashPattern();
        }
        return new float[0];
    }

    @Override
    public Shape getShape() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(1);
        for (Sprite sprite : this.sprites) {
            generalPath.append(sprite.getShape(), false);
        }
        generalPath.transform(this.transform);
        return generalPath;
    }

    @Override
    public boolean intersects(double d, double d2) {
        boolean bl = false;
        if (this.getBounds2D().getMinX() <= d && d < this.getBounds2D().getMaxX() && this.getBounds2D().getMinY() <= d2 && d2 < this.getBounds2D().getMaxY()) {
            if (!this.getUseBoundingBox()) {
                Location2D location2D = this.getFrameLocation(d, d2);
                for (Sprite sprite : this.sprites) {
                    if (!sprite.intersects(location2D)) continue;
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean intersects(Sprite sprite) {
        boolean bl = false;
        if (this.getBounds2D().intersects(sprite)) {
            if (!this.getUseBoundingBox()) {
                for (Sprite sprite2 : this.sprites) {
                    AffineTransform affineTransform = (AffineTransform)sprite2.transform.clone();
                    sprite2.transform = (AffineTransform)this.transform.clone();
                    sprite2.transform.concatenate(affineTransform);
                    bl = bl || sprite2.intersects(sprite);
                    sprite2.transform = affineTransform;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public void normalizeSprites() {
        Object object;
        if (this.sprites.size() == 0) {
            return;
        }
        Location2D location2D = this.sprites.get(0).getLocation();
        Location2D location2D2 = this.sprites.get(0).getLocation();
        for (Sprite sprite : this.sprites) {
            object = sprite.getBounds2D();
            location2D.x = Math.min(location2D.x, ((Box2D)object).getMinX());
            location2D.y = Math.min(location2D.y, ((Box2D)object).getMinY());
            location2D2.x = Math.max(location2D2.x, ((Box2D)object).getMaxX());
            location2D2.y = Math.max(location2D2.y, ((Box2D)object).getMaxY());
        }
        double d = 1.0 / Math.max(location2D2.x - location2D.x, location2D2.y - location2D.y);
        object = new Location2D(-(location2D.x + location2D2.x) / 2.0, -(location2D.y + location2D2.y) / 2.0);
        for (Sprite sprite : this.sprites) {
            sprite.translate((Location2D)object);
            sprite.setX(sprite.getX() * d);
            sprite.setY(sprite.getY() * d);
            sprite.scale(d);
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        for (Sprite sprite : this.sprites) {
            if (!sprite.isVisible()) continue;
            Location2D location2D = sprite.getLocation();
            Location2D location2D2 = sprite.getLocation();
            double d = this.getScale();
            double d2 = this.getRotation();
            location2D2.x *= d;
            location2D2.y *= d;
            AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
            affineTransform.concatenate(AffineTransform.getRotateInstance(d2));
            affineTransform.transform(location2D, location2D2);
            sprite.setLocation(location2D2);
            sprite.translate(this.getLocation());
            sprite.scale(d);
            sprite.rotate(d2);
            sprite.paint(graphics2D);
            sprite.rotate(-d2);
            sprite.scale(1.0 / d);
            sprite.setLocation(location2D);
        }
    }

    public void removeSprite(Sprite sprite) {
        this.sprites.remove(sprite);
    }

    private void paintCrosshairs(Graphics2D graphics2D) {
        Line2D.Double double_ = new Line2D.Double(0.0, -0.2, 0.0, 0.2);
        Line2D.Double double_2 = new Line2D.Double(-0.2, 0.0, 0.2, 0.0);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
    }

    @Override
    protected void drawDebugShapes(Graphics2D graphics2D) {
        super.drawDebugShapes(graphics2D);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.transform(this.transform);
        this.setDebugBrush(debugCrosshairsColor, graphics2D);
        this.paintCrosshairs(graphics2D);
        graphics2D.setTransform(affineTransform);
    }

    @Override
    public void update() {
        for (Sprite sprite : this.sprites) {
            Game game = Game.getCurrentGame();
            if (game != null && !game.containsSprite(sprite)) {
                sprite.applyTransformerNG();
            }
            sprite.update();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[x = " + this.getX() + ", y = " + this.getY() + "], " + "[w = " + this.getWidth() + ", h = " + this.getHeight() + "] " + this.sprites;
    }

    @Override
    public void reportTransformers(Set<Transformer> set) {
        super.reportTransformers(set);
        for (Sprite sprite : this.sprites) {
            Game game = Game.getCurrentGame();
            if (game == null || game.containsSprite(sprite)) continue;
            sprite.reportTransformers(set);
        }
    }
}

