/*
 * Decompiled with CFR 0.152.
 */
package fang2.network;

import fang2.network.GameConnections;
import fang2.network.HttpServerSocket;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class HttpServer
extends Thread {
    public static int PORT = 1554;
    private HashMap<String, GameConnections> games = new HashMap();
    private boolean connected = true;
    private ObjectOutputStream pipedOut;
    private ObjectInputStream pipedIn;
    private ServerSocket serverSocket;

    public HttpServer(Object object) {
    }

    public HttpServer() throws IOException {
        this.serverSocket = new HttpServerSocket(PORT);
    }

    public ObjectInputStream getPipedInput() {
        try {
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            PipedInputStream pipedInputStream = new PipedInputStream();
            pipedOutputStream.connect(pipedInputStream);
            this.pipedOut = new ObjectOutputStream(pipedOutputStream);
            return new ObjectInputStream(pipedInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.pipedOut = null;
            return null;
        }
    }

    public ObjectOutputStream getPipedOutput() {
        try {
            PipedInputStream pipedInputStream = new PipedInputStream();
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            pipedInputStream.connect(pipedOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(pipedOutputStream);
            this.pipedIn = new ObjectInputStream(pipedInputStream);
            return objectOutputStream;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.pipedIn = null;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPipes() {
        if (this.pipedOut != null && this.pipedIn != null) {
            new Dispatcher(this.pipedOut, this.pipedIn).start();
        } else {
            System.err.println("cannot start pipes");
        }
        HttpServer httpServer = this;
        synchronized (httpServer) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void connect() {
        while (this.connected) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                break;
            }
            try {
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write("?PNG".getBytes());
                outputStream.write(13);
                outputStream.write(10);
                outputStream.write(26);
                outputStream.write(10);
                outputStream.flush();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.flush();
                ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(socket.getInputStream(), 100));
                new Dispatcher(objectOutputStream, objectInputStream).start();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void disconnect() {
        this.connected = false;
    }

    public void run() {
        if (this.pipedIn == null && this.pipedOut == null) {
            this.connect();
        } else {
            this.startPipes();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        new HttpServer().connect();
    }

    class Dispatcher
    extends Thread {
        ObjectOutputStream out;
        ObjectInputStream in;

        public Dispatcher(ObjectOutputStream objectOutputStream, ObjectInputStream objectInputStream) {
            this.out = objectOutputStream;
            this.in = objectInputStream;
        }

        private boolean joinGame(String string) throws IOException {
            GameConnections gameConnections;
            String[] stringArray = string.split(" ");
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            String string4 = "Game: " + string2 + " Session: " + string3;
            int n = 2;
            if (stringArray.length > 3) {
                n = Math.max(1, Integer.parseInt(stringArray[3]));
            }
            if ((gameConnections = (GameConnections)HttpServer.this.games.get(string4)) == null) {
                gameConnections = new GameConnections(string2, string3, n);
                HttpServer.this.games.put(string4, gameConnections);
            }
            if (gameConnections.isFull()) {
                this.out.writeObject("Game already full");
                this.out.flush();
                return false;
            }
            boolean bl = gameConnections.addConnection(this.out, this.in);
            if (gameConnections.isFull()) {
                HttpServer.this.games.remove(string4);
            }
            return bl;
        }

        private void listGames() throws IOException {
            String[] stringArray = HttpServer.this.games.keySet().toArray(new String[0]);
            String string = "happy\n";
            for (String string2 : stringArray) {
                if (((GameConnections)HttpServer.this.games.get(string2)).isFull()) continue;
                string = string + string2 + "\n";
            }
            this.out.writeObject(string);
            this.out.flush();
        }

        private void cleanEmptyGames() {
            Set set = HttpServer.this.games.entrySet();
            LinkedList linkedList = new LinkedList();
            for (Map.Entry entry : set) {
                if (((GameConnections)entry.getValue()).isActive()) continue;
                linkedList.add(entry.getKey());
            }
            for (Map.Entry entry : linkedList) {
                HttpServer.this.games.remove(entry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String string;
                block9: {
                    while (true) {
                        string = (String)this.in.readObject();
                        this.cleanEmptyGames();
                        if (string.startsWith("Join")) {
                            if (!this.joinGame(string)) continue;
                            break block9;
                        }
                        if (string.startsWith("List Games")) {
                            this.listGames();
                            continue;
                        }
                        if (string.startsWith("Quit")) break;
                    }
                    return;
                }
                Dispatcher dispatcher = this;
                synchronized (dispatcher) {
                    int n = Integer.parseInt(string.split(" ")[3]);
                    if (n == 1) {
                        this.wait();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

