/*
 * Decompiled with CFR 0.152.
 */
package fang2.media;

import fang2.media.SampledSound;
import fang2.media.SequentialSound;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;

public class MidiSound
extends SequentialSound {
    private Sequencer sequencer;
    private URL soundFile;
    private boolean loaded = false;
    private boolean muted;
    private boolean paused;
    private long startTime;
    private static Loader loader;
    private static HashMap<URL, byte[]> cachedSounds;

    public MidiSound(URL uRL) {
        this.soundFile = uRL;
        if (loader == null) {
            loader = new Loader();
            loader.start();
        }
        this.loaded = cachedSounds.containsKey(uRL);
        if (!this.loaded) {
            loader.load(this);
        } else {
            this.prepareForPlaying();
        }
    }

    private void prepareForPlaying() {
        try {
            this.sequencer = MidiSystem.getSequencer();
            MidiSystem.getSequence(new ByteArrayInputStream(cachedSounds.get(this.soundFile)));
            Sequence sequence = MidiSystem.getSequence(new ByteArrayInputStream(cachedSounds.get(this.soundFile)));
            this.sequencer.setSequence(sequence);
            this.sequencer.open();
            if (this.startTime > 0L) {
                long l = (System.currentTimeMillis() - this.startTime) * 1000L;
                this.sequencer.setMicrosecondPosition(l);
                this.sequencer.start();
            }
            this.loaded = true;
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void loadDataFromURL() {
        try {
            if (!cachedSounds.containsKey(this.soundFile)) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                InputStream inputStream = this.soundFile.openStream();
                byte[] byArray = new byte[32768];
                int n = inputStream.read(byArray);
                while (n >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                cachedSounds.put(this.soundFile, byArray2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        URL uRL = SampledSound.class.getResource("YMCA.mid");
        MidiSound midiSound = new MidiSound(uRL);
        midiSound.play();
    }

    public double getClipLength() {
        return (double)this.sequencer.getMicrosecondLength() / 1000000.0;
    }

    public double getClipPosition() {
        return (double)this.sequencer.getMicrosecondPosition() / 1000000.0;
    }

    public SequentialSound getDuplicate() {
        MidiSound midiSound = new MidiSound(this.soundFile);
        midiSound.setVolume(this.getVolume());
        midiSound.setPan(this.getPan());
        if (this.isPaused()) {
            midiSound.pause();
        } else {
            midiSound.resume();
        }
        if (this.isMuted()) {
            midiSound.mute();
        } else {
            midiSound.turnSoundOn();
        }
        return midiSound;
    }

    public int getLoopsLeft() {
        return this.sequencer.getLoopCount();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isPlaying() {
        return this.sequencer.isRunning();
    }

    public void loop() {
        this.sequencer.setLoopCount(-1);
    }

    public void mute() {
        if (!this.muted) {
            this.muted = true;
            int n = this.sequencer.getSequence().getTracks().length;
            for (int i = 0; i < n; ++i) {
                this.sequencer.setTrackMute(i, true);
            }
        }
    }

    public void pause() {
        if (!this.paused) {
            this.paused = true;
            this.sequencer.stop();
        }
    }

    public void play() {
        if (!this.loaded) {
            this.startTime = System.currentTimeMillis();
        } else {
            this.paused = false;
            this.sequencer.setMicrosecondPosition(0L);
            this.sequencer.start();
        }
    }

    public void setLooping(boolean bl) {
        if (bl) {
            this.sequencer.setLoopCount(-1);
        } else {
            this.sequencer.setLoopCount(0);
        }
    }

    public void setLooping(int n) {
        this.sequencer.setLoopCount(n);
    }

    public void setPan(double d) {
        super.setPan(d);
    }

    public void setVolume(double d) {
        super.setVolume(d);
    }

    public void stop() {
        this.sequencer.stop();
    }

    public void turnSoundOn() {
        if (this.muted) {
            this.muted = false;
            int n = this.sequencer.getSequence().getTracks().length;
            for (int i = 0; i < n; ++i) {
                this.sequencer.setTrackMute(i, false);
            }
        }
    }

    public void setClipPosition(double d) {
        this.sequencer.setMicrosecondPosition((long)(d * 1000000.0));
    }

    static {
        cachedSounds = new HashMap();
    }

    static class Loader
    extends Thread {
        private LinkedList<MidiSound> queue = new LinkedList();

        Loader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(MidiSound midiSound) {
            LinkedList<MidiSound> linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.add(midiSound);
                this.queue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                LinkedList<MidiSound> linkedList = this.queue;
                synchronized (linkedList) {
                    if (!this.queue.isEmpty()) {
                        MidiSound midiSound = this.queue.removeFirst();
                        midiSound.loadDataFromURL();
                        midiSound.prepareForPlaying();
                    } else {
                        try {
                            this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

